#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import re

MAX_DEC = 16777215
MAX_STEPS = 10000
MAX_RANDOM_COLORS = 100
DEDUP_DELTA_E_LAB = 7.7
DEDUP_DELTA_E_OKLAB = 0.077
DEDUP_DELTA_E_RGB = 27
SRGB_TO_LINEAR_TH = 0.04045
LINEAR_TO_SRGB_TH = 0.0031308
EPS = 1e-12

__version__ = "0.0.1"

HEX_REGEX = re.compile(r"^(?:[0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})$")

TECH_INFO_KEYS = [
    'index', 'red_green_blue', 'luminance', 'hue_saturation_lightness',
    'hsv', 'cmyk', 'contrast', 'xyz', 'lab', 'lightness_chroma_hue',
    'hue_whiteness_blackness', 'oklab', 'oklch', 'cieluv', 'similar', 'name',
]

SCHEME_KEYS = [
    'complementary', 'split_complementary', 'analogous', 'triadic',
    'tetradic_square', 'tetradic_rectangular', 'monochromatic'
]

SIMULATE_KEYS = [
    'protanopia', 'deuteranopia', 'tritanopia', 'achromatopsia'
]

CB_MATRICES = {
    "Protanopia": [
        [0.56667, 0.43333, 0],
        [0.55833, 0.44167, 0],
        [0, 0.24167, 0.75833]
    ],
    "Deuteranopia": [
        [0.625, 0.375, 0],
        [0.70, 0.30, 0],
        [0, 0.30, 0.70]
    ],
    "Tritanopia": [
        [0.95, 0.05, 0],
        [0, 0.43333, 0.56667],
        [0, 0.475, 0.525]
    ],
}

FORMAT_ALIASES = {
    'hex': 'hex',
    'index': 'index',
    'rgb': 'rgb',
    'redgreenblue': 'rgb',
    'hsl': 'hsl',
    'huesaturationlightness': 'hsl',
    'hsv': 'hsv',
    'huesaturationvalue': 'hsv',
    'hwb': 'hwb',
    'huewhitenessblackness': 'hwb',
    'cmyk': 'cmyk',
    'cyanmagentayellowkey': 'cmyk',
    'xyz': 'xyz',
    'ciexyz': 'xyz',
    'lab': 'lab',
    'cielab': 'lab',
    'lch': 'lch',
    'cielch': 'lch',
    'oklab': 'oklab',
    'name': 'name',
    'luv': 'luv',
    'cieluv': 'luv',
    'oklch': 'oklch',
    'cielchok': 'oklch',
    'srgblinear': 'srgb-linear',
}

COLOR_NAMES = {
    'acidgreen': '8FFE09',
    'adobe': 'BD6C48',
    'algae': '54AC68',
    'algaegreen': '21C36F',
    'aliceblue': 'F0F8FF',
    'almostblack': '070D0D',
    'amethyst': '9B5FC0',
    'antiquewhite': 'FAEBD7',
    'apple': '6ECB3C',
    'applegreen': '76CD26',
    'apricot': 'FFB16D',
    'aqua': '00FFFF',
    'aquamarine': '7FFFD4',
    'armygreen': '4B5320',
    'asparagus': '77AB56',
    'aubergine': '3D0734',
    'auburn': '9A3001',
    'avocado': '90B134',
    'avocadogreen': '87AE22',
    'azul': '1D5DEC',
    'azure': 'F0FFFF',
    'babyblue': 'A2CFFE',
    'babygreen': '8CFF9E',
    'babypink': 'FFB7CE',
    'banana': 'FFFF7E',
    'bananayellow': 'FAFE4B',
    'barbiepink': 'FE46A5',
    'barney': 'AC1DB8',
    'battleshipgrey': '6B7C85',
    'beige': 'F5F5DC',
    'berry': '990F4B',
    'bile': 'B5C306',
    'bisque': 'FFE4C4',
    'black': '000000',
    'blanchedalmond': 'FFEBCD',
    'bland': 'AFA88B',
    'blood': '770001',
    'bloodorange': 'FE4B03',
    'bloodred': '980002',
    'blue': '0000FF',
    'blueberry': '464196',
    'blueblue': '2242C7',
    'bluegreen': '0F9B8E',
    'bluegrey': '85A3B2',
    'bluepurple': '5721CB',
    'blueviolet': '8A2BE2',
    'bluewithahintofpurple': '533CC6',
    'bluish': '2976BB',
    'bluishgreen': '10A674',
    'bluishgrey': '748B97',
    'bluishpurple': '703BE7',
    'blush': 'F29E8E',
    'blushpink': 'FE828C',
    'booger': '9BB53C',
    'boogergreen': '96B403',
    'bordeaux': '7B002C',
    'boringgreen': '63B365',
    'bottlegreen': '044A05',
    'brightblue': '0165FC',
    'brightcyan': '0AFFFE',
    'brightgreen': '01FF07',
    'brightlightblue': '26F7FD',
    'brightlightgreen': '2DFE54',
    'brightlime': '87FD05',
    'brightlimegreen': '89FE05',
    'brightmagenta': 'FF08E8',
    'brightolive': '9CBB04',
    'brightorange': 'FF5B00',
    'brightpink': 'FE019A',
    'brightpurple': 'BE03FD',
    'brightred': 'FF000D',
    'brightseagreen': '05FFA6',
    'brightskyblue': '02CCFE',
    'brightteal': '01F9C6',
    'brightturquoise': '0FFEF9',
    'brightviolet': 'AD03DE',
    'brightyellow': 'FFFD01',
    'brightyellowgreen': '9DFF00',
    'britishracinggreen': '05480D',
    'bronze': 'A87900',
    'brown': 'A52A2A',
    'browngreen': '706C11',
    'browngrey': '877970',
    'brownish': '7B5B47',
    'brownishgreen': '6A6E09',
    'brownishgrey': '86775F',
    'brownishorange': 'CB6F10',
    'brownishpink': 'C27E79',
    'brownishpurple': '76424E',
    'brownishred': '9E3623',
    'brownishyellow': 'C9B003',
    'brownyellow': 'B59F06',
    'bruise': '7E4071',
    'bubblegum': 'FF69AF',
    'bubblegumpink': 'FE83CC',
    'buff': 'FEF69E',
    'burgundy': '610023',
    'burlywood': 'DEB887',
    'burntorange': 'C05600',
    'burntred': '9F2305',
    'burntsienna': 'B04E0F',
    'burntumber': 'A0450E',
    'burntyellow': 'D5AB09',
    'burple': '6832E3',
    'burro': '827A6C',
    'butter': 'FFFF81',
    'butterscotch': 'FDB147',
    'butteryellow': 'FFFD74',
    'byzantium': '702963',
    'cadetblue': '5F9EA0',
    'camel': 'C69F59',
    'camouflagegreen': '4B5D16',
    'canary': 'FDFF63',
    'canaryyellow': 'FFFE40',
    'candypink': 'FF63E9',
    'caramel': 'AF6F09',
    'carmine': '9D0216',
    'carnation': 'FD798F',
    'carnationpink': 'FF7FA7',
    'carolinablue': '8AB8FE',
    'celadon': 'BEFDB7',
    'celery': 'C1FD95',
    'cement': '7B7B7A',
    'cerise': 'DE0C62',
    'cerulean': '0485D1',
    'ceruleanblue': '056EEE',
    'champagne': 'F7E7CE',
    'charcoal': '343837',
    'charcoalgrey': '3C4142',
    'chartreuse': '7FFF00',
    'cherry': 'C20402',
    'cherryred': 'C2000B',
    'chestnut': '742802',
    'chocolate': 'D2691E',
    'chocolatebrown': '411900',
    'cinnamon': 'AC4F06',
    'claret': '680018',
    'clay': 'B66A50',
    'claybrown': 'B2713D',
    'clearblue': '247AFD',
    'cloudyblue': 'ACC2D9',
    'cobalt': '1E488F',
    'cobaltblue': '030AA7',
    'cocoa': '8A6642',
    'coffee': '6F4E37',
    'coolblue': '4984B8',
    'coolgreen': '33B864',
    'coolgrey': '95A3A6',
    'copper': 'B66325',
    'coral': 'FF7F50',
    'coralpink': 'FF6163',
    'cornflower': '6A79F7',
    'cornflowerblue': '6495ED',
    'cornsilk': 'FFF8DC',
    'cranberry': '9E003A',
    'cream': 'FFFFC2',
    'creme': 'FFFFB6',
    'crimson': 'DC143C',
    'cyan': '00FEFF',
    'cybergrape': '58427C',
    'dandelion': 'FEDF08',
    'dark': '1B2431',
    'darkaqua': '05696B',
    'darkaquamarine': '017351',
    'darkblue': '00035B',
    'darkbluegreen': '005249',
    'darkbluegrey': '1F3B4D',
    'darkbrown': '341C02',
    'darkbrowngreen': '3A3401',
    'darkcoral': 'B04E4B',
    'darkcyan': '008B8C',
    'darkforestgreen': '002D04',
    'darkgold': 'B59410',
    'darkgoldenrod': 'B8860B',
    'darkgrassgreen': '388004',
    'darkgray': 'A9A9A9',
    'darkgreen': '006400',
    'darkgreenblue': '1F6357',
    'darkgrey': '363737',
    'darkgreyblue': '29465B',
    'darkhotpink': 'D90166',
    'darkindigo': '1F0954',
    'darkishblue': '014182',
    'darkishgreen': '287C37',
    'darkishpink': 'DA467D',
    'darkishpurple': '751973',
    'darkishred': 'A0020C',
    'darkkhaki': 'BDB76B',
    'darklavender': '856798',
    'darklime': '84B701',
    'darklimegreen': '7EBD01',
    'darkmagenta': '8B008B',
    'darkmaroon': '3C0008',
    'darkmint': '48C072',
    'darkmintgreen': '20C273',
    'darkmustard': 'A88905',
    'darknavy': '00022E',
    'darkolive': '373E02',
    'darkolivegreen': '556B2F',
    'darkorange': 'FF8C00',
    'darkorchid': '9932CC',
    'darkpastelgreen': '56AE57',
    'darkpeach': 'DE7E5D',
    'darkperiwinkle': '665FD1',
    'darkpink': 'CB416B',
    'darkplum': '3F012C',
    'darkpurple': '35063E',
    'darkred': '8B0000',
    'darkrose': 'B5485D',
    'darkroyalblue': '02066F',
    'darksage': '598556',
    'darksalmon': 'E9967A',
    'darksand': 'A88F59',
    'darkseafoam': '1FB57A',
    'darkseafoamgreen': '3EAF8E',
    'darkseagreen': '8FBC8F',
    'darkskyblue': '448EE4',
    'darkslateblue': '483D8B',
    'darkslategray': '2F4F4F',
    'darkslategrey': '314F4F',
    'darktan': 'A1804B',
    'darkteal': '014D4E',
    'darkturquoise': '00CED1',
    'darkviolet': '9400D3',
    'darkyellow': 'D5B60A',
    'darkyellowgreen': '728F02',
    'deepaqua': '08787F',
    'deepblue': '040273',
    'deepbrown': '410200',
    'deepgreen': '02590F',
    'deeplilac': '966EBD',
    'deepmagenta': 'A0025C',
    'deeporange': 'DC4D01',
    'deeppink': 'FF1493',
    'deeppurple': '36013F',
    'deepred': '9A0200',
    'deeprose': 'C74767',
    'deepseablue': '015482',
    'deepskyblue': '00BFFF',
    'deepteal': '00555A',
    'deepturquoise': '017374',
    'deepviolet': '490648',
    'denim': '3B5B92',
    'desert': 'CCAD60',
    'dimgray': '696969',
    'dimgrey': '686868',
    'dirt': '8A6E45',
    'dirtbrown': '836539',
    'dirtyblue': '3F829D',
    'dirtygreen': '667E2C',
    'dirtyorange': 'C87606',
    'dirtypink': 'CA7B80',
    'dirtypurple': '734A65',
    'dirtyyellow': 'CDC50A',
    'dodgerblue': '1E90FF',
    'drab': '82774E',
    'drabgreen': '749551',
    'driedblood': '4B0101',
    'duckeggblue': 'C3FBF4',
    'dullblue': '49759C',
    'dullgreen': '74A662',
    'dullorange': 'D8863B',
    'dullpink': 'D5869D',
    'dullpurple': '84597E',
    'dullred': 'BB3F3F',
    'dullteal': '5F9E8F',
    'dullyellow': 'EEDC5B',
    'dusk': '4E5481',
    'duskblue': '26538D',
    'dust': 'B2996E',
    'dustyblue': '5A86AD',
    'dustygreen': '76A973',
    'dustylavender': 'AC86A8',
    'dustyorange': 'F0833A',
    'dustypink': 'D58A94',
    'dustypurple': '825F87',
    'dustyred': 'B9484E',
    'dustyrose': 'C0737A',
    'dustyteal': '4C9085',
    'earth': 'A2653E',
    'eastergreen': '8CFD7E',
    'easterpurple': 'C071FE',
    'ecru': 'FEFFCA',
    'eggplant': '380835',
    'eggplantpurple': '44012C',
    'eggshell': 'FFFCC4',
    'eggshellblue': 'C4FFF7',
    'electricblue': '0652FF',
    'electricgreen': '21FC0D',
    'electriclime': 'A8FF04',
    'electricpink': 'FF0490',
    'electricpurple': 'A200FF',
    'emerald': '01A049',
    'emeraldgreen': '028F1E',
    'erin': '00FF3F',
    'evergreen': '05472A',
    'fadedblue': '658CBB',
    'fadedgreen': '7BB274',
    'fadedpink': 'DE9DAC',
    'fadedpurple': '887191',
    'fadedyellow': 'FEFDE7',
    'fawn': 'CFA76E',
    'fern': '63A950',
    'ferngreen': '548D44',
    'firebrick': 'B22222',
    'fireenginered': 'FE0002',
    'flatblue': '3C73A8',
    'flatgreen': '699D4C',
    'floralwhite': 'FFFAF0',
    'fluorescentgreen': '08FF08',
    'flurogreen': '0AFF02',
    'foamgreen': '90FDA9',
    'forest': '0B5509',
    'forestgreen': '228B22',
    'forrestgreen': '154406',
    'frenchblue': '436B95',
    'freshgreen': '69D84F',
    'froly': 'F2798E',
    'fuchsia': 'FF00FF',
    'gainsboro': 'DCDCDC',
    'ghostwhite': 'F8F8FF',
    'gold': 'FFD700',
    'golden': 'F5BF03',
    'goldenbrown': '966909',
    'goldenrod': 'DAA520',
    'goldenyellow': 'FEC615',
    'grape': '6C3461',
    'grapepurple': '5D1451',
    'grass': '5CAC2D',
    'grassgreen': '3F9B0B',
    'grassygreen': '419C03',
    'gray': 'BEBEBE',
    'grayblue': '6B8BA4',
    'graybrown': '7A6A4F',
    'green': '008000',
    'greenapple': '5EDC1F',
    'greenblue': '01C08D',
    'greenbrown': '544E03',
    'greengrey': '9CA994',
    'greenish': '40A368',
    'greenishbeige': 'C9D179',
    'greenishbrown': '696112',
    'greenishcyan': '2AFEB7',
    'greenishtan': 'BCCB7A',
    'greenishteal': '32BF84',
    'greenishturquoise': '00FBB0',
    'greenishyellow': 'C9FF27',
    'greenteal': '0CB577',
    'greenyellow': 'ADFF2F',
    'grey': '808080',
    'greyblue': '77A1B5',
    'greybrown': '7F7053',
    'greygreen': '86A17D',
    'greyish': 'A8A495',
    'greyishblue': '5E819D',
    'greyishgreen': '82A67D',
    'greyishpink': 'C88D94',
    'greyishteal': '719F94',
    'greypink': 'C3909B',
    'greypurple': '826D8C',
    'greyteal': '5E9B8A',
    'grossgreen': 'A0BF16',
    'gunmetal': '536267',
    'harlequin': '3FFF00',
    'hazel': '8E7618',
    'heather': 'A484AC',
    'heliotrope': 'D94FF5',
    'highlightergreen': '1BFC06',
    'honeydew': 'F0FFF0',
    'hospitalgreen': '9BE5AA',
    'hotgreen': '25FF29',
    'hotmagenta': 'F504C9',
    'hotpink': 'FF69B4',
    'hotpurple': 'CB00F5',
    'huntergreen': '0B4008',
    'ice': 'D6FFFA',
    'iceblue': 'D7FFFE',
    'ickygreen': '8FAE22',
    'indianred': 'CD5C5C',
    'indigo': '4B0082',
    'indigoblue': '3A18B1',
    'iris': '625AFA',
    'irishgreen': '019529',
    'ivory': 'FFFFF0',
    'jade': '1FA774',
    'jadegreen': '2BAF6A',
    'junglegreen': '048243',
    'kelleygreen': '009337',
    'kellygreen': '02AB2E',
    'khaki': 'F0E68C',
    'khakigreen': '728639',
    'kiwi': '9CEF43',
    'kiwigreen': '8EE53F',
    'lavender': 'E6E6FA',
    'lavenderblue': '8B88F8',
    'lavenderblush': 'FFF0F5',
    'lavenderpink': 'DD85D7',
    'lawngreen': '7CFC00',
    'leaf': '71AA34',
    'leafgreen': '5CA904',
    'leafygreen': '51B73B',
    'lemon': 'FDE910',
    'lemonchiffon': 'FFFACD',
    'lemongreen': 'ADF802',
    'lemonlime': 'BFFE28',
    'lemonyellow': 'FDFF38',
    'licorice': '1A0101',
    'lightaqua': '8CFFDB',
    'lightaquamarine': '7BFDC7',
    'lightbeige': 'FFFEB6',
    'lightblue': 'ADD8E6',
    'lightbluegreen': '7EFBB3',
    'lightbluegrey': 'B7C9E2',
    'lightbrightgreen': '53FE5C',
    'lightbrown': 'AD8150',
    'lightburgundy': 'A8415B',
    'lightcoral': 'F08080',
    'lightcyan': 'E0FFFF',
    'lighteggplant': '894585',
    'lightforestgreen': '4F9153',
    'lightgold': 'FDDC5C',
    'lightgolden': 'EEDD82',
    'lightgoldenrodyellow': 'FAFAD2',
    'lightgrape': 'AB8CE4',
    'lightgrassgreen': '9AF72D',
    'lightgray': 'D3D3D3',
    'lightgreen': '90EE90',
    'lightgrey': 'D8DCD6',
    'lightgreyblue': '9DBCD4',
    'lightgreygreen': 'B7E1A1',
    'lightgreyishgreen': '96B791',
    'lightishblue': '3D7AFD',
    'lightishgreen': '61E160',
    'lightishpurple': 'A552E6',
    'lightkhaki': 'F0E98C',
    'lightlavender': 'DFC5FE',
    'lightlightblue': 'CAFFFB',
    'lightlime': 'AEFD6C',
    'lightlimegreen': 'B9FF66',
    'lightmagenta': 'FA5FF7',
    'lightmaroon': 'A26565',
    'lightmauve': 'C292A1',
    'lightmint': 'B6FFBB',
    'lightmintgreen': 'A6FBB2',
    'lightmossgreen': 'A6C875',
    'lightmustard': 'F7D560',
    'lightnavy': '155084',
    'lightnavyblue': '2E5A88',
    'lightneongreen': '4EFD54',
    'lightolive': 'ACBF69',
    'lightolivegreen': 'A4BE5C',
    'lightorange': 'FDAA48',
    'lightorchid': 'E6A8D7',
    'lightpastelgreen': 'B2FBA5',
    'lightpeach': 'FFD8B1',
    'lightperiwinkle': 'C1C6FC',
    'lightpink': 'FFB6C1',
    'lightplum': '9D5783',
    'lightpurple': 'F2C1F3',
    'lightred': 'FF474C',
    'lightrose': 'FFC5CB',
    'lightroyalblue': '3A2EFE',
    'lightsage': 'BCECAC',
    'lightsalmon': 'FFA07A',
    'lightseafoamgreen': 'A7FFB5',
    'lightseagreen': '20B2AA',
    'lightskyblue': '87CEFA',
    'lightslategray': '778899',
    'lightslategrey': '778898',
    'lightsteelblue': 'B0C4DE',
    'lighttan': 'FBEEAC',
    'lightteal': '90FCF9',
    'lighttoxicgreen': '76FF7B',
    'lightturquoise': 'AFE4DE',
    'lighturple': 'B36FF6',
    'lightviolet': 'D6B4FC',
    'lightyellow': 'FFFFE0',
    'lightyellowgreen': 'CCFD7F',
    'lightyellowishgreen': 'C2FF89',
    'lilac': 'CEA2FD',
    'lime': '00FF00',
    'limegreen': '32CD32',
    'limeyellow': 'D0FE1D',
    'linen': 'FAF0E6',
    'lipstick': 'C0022F',
    'macaroniandcheese': 'EFB435',
    'magenta': 'FF00FE',
    'mahogany': '4A0100',
    'maize': 'F4D054',
    'mango': 'FFA62B',
    'manilla': 'FFFA86',
    'marigold': 'FCC006',
    'marine': '042E60',
    'marineblue': '01386A',
    'maroon': 'B03060',
    'mauve': 'AE7181',
    'mediumaquamarine': '66CDAA',
    'mediumblue': '0000CD',
    'mediumbrown': '7F5112',
    'mediumgreen': '39AD48',
    'mediumgrey': '7D7D74',
    'mediumorchid': 'BA55D3',
    'mediumpink': 'F36196',
    'mediumpurple': '9370DB',
    'mediumseagreen': '3CB371',
    'mediumslateblue': '7B68EE',
    'mediumspringgreen': '00FA9A',
    'mediumturquoise': '48D1CC',
    'mediumvioletred': 'C71585',
    'melon': 'FF7855',
    'merlot': '730039',
    'metallicblue': '4F738E',
    'midgreen': '50A747',
    'midnight': '03012D',
    'midnightblue': '191970',
    'midnightpurple': '280137',
    'militarygreen': '667C3E',
    'mint': '98FF98',
    'mintcream': 'F5FFFA',
    'mintgreen': '8FFF9F',
    'mintygreen': '0BF77D',
    'mistyrose': 'FFE4E1',
    'moccasin': 'FFE4B5',
    'moss': '769958',
    'mossgreen': '658B38',
    'mossygreen': '638B27',
    'mud': '735B3A',
    'mudbrown': '60460F',
    'muddybrown': '886831',
    'muddygreen': '657432',
    'muddyyellow': 'BFAC05',
    'mudgreen': '606602',
    'mulberry': '920A4E',
    'murkygreen': '6C7A0E',
    'mushroom': 'C9B29B',
    'mustard': 'CEB301',
    'mustardbrown': 'A98002',
    'mustardgreen': 'A8B504',
    'mustardyellow': 'D2B100',
    'mutedblue': '3B719F',
    'mutedgreen': '5FA052',
    'mutedpink': 'D1768F',
    'mutedpurple': '805B87',
    'nastygreen': '70B23F',
    'navajowhite': 'FFDEAD',
    'navy': '000080',
    'navyblue': '000435',
    'neonblue': '04D9FF',
    'neongreen': '0CFF0C',
    'neonpurple': 'BC13FE',
    'neonred': 'FF0701',
    'neonyellow': 'CFFF04',
    'niceblue': '107AB0',
    'nightblue': '040348',
    'ocean': '017B92',
    'oceanblue': '03719C',
    'oceanboatblue': '0077BE',
    'oceangreen': '3D9973',
    'ochre': 'BF9005',
    'offblue': '5684AE',
    'offgreen': '6BA353',
    'offwhite': 'FFFFE4',
    'offyellow': 'F1F33F',
    'oldlace': 'FDF5E6',
    'oldpink': 'C77986',
    'oldrose': 'C87F89',
    'olive': '808000',
    'olivebrown': '645403',
    'olivedrab': '6B8E23',
    'olivegreen': '677A04',
    'oliveyellow': 'C2B709',
    'opal': 'A9C8C9',
    'orange': 'FFA500',
    'orangebrown': 'BE6400',
    'orangeish': 'FD8D49',
    'orangepink': 'FF6F52',
    'orangered': 'FF4500',
    'orangeybrown': 'B16002',
    'orangeyellow': 'FFAD01',
    'orangeyred': 'FA4224',
    'orangeyyellow': 'FDB915',
    'orchid': 'DA70D6',
    'pale': 'FFF9D0',
    'paleaqua': 'B8FFEB',
    'paleblue': 'D0FEFE',
    'palebrown': 'A1805B',
    'palecyan': 'B7FFFA',
    'palegoldenrod': 'EEE8AA',
    'palegreen': '98FB98',
    'palegrey': 'FDFDFE',
    'palelavender': 'EECFFE',
    'palelime': 'DEFD73',
    'palelimegreen': 'B1FF65',
    'palemagenta': 'D388B7',
    'palemauve': 'FED0FC',
    'paleolive': 'B9CC81',
    'paleolivegreen': 'B1D27B',
    'paleorange': 'FFB07C',
    'palepeach': 'FFC8A8',
    'palepink': 'FFCFDC',
    'palepurple': 'B790D4',
    'palered': 'D9544D',
    'palesalmon': 'FFB19A',
    'paleskyblue': 'BDF6FE',
    'paleteal': '82CBB2',
    'paleturquoise': 'AFEEEE',
    'paleviolet': 'CEAEFA',
    'palevioletred': 'DB7093',
    'paleyellow': 'FFFE86',
    'papayawhip': 'FFEFD5',
    'parchment': 'FEFCAF',
    'pastelblue': 'A2BFFE',
    'pastelgreen': 'B0FF9D',
    'pastelorange': 'FF964F',
    'pastelpink': 'FFBACD',
    'pastelpurple': 'B296FE',
    'pastelred': 'FF6961',
    'pastelyellow': 'FFFE71',
    'peachpuff': 'FFDAB9',
    'peacockblue': '016795',
    'peagreen': '8EAB12',
    'pear': 'CBF85F',
    'peasoup': '94A617',
    'periwinkle': '8F8CE7',
    'peru': 'CD853F',
    'petrol': '005F6A',
    'pigpink': 'E78EA5',
    'pine': '2B5D34',
    'pinegreen': '0A481E',
    'pink': 'FFC0CB',
    'pinkish': 'D46A7E',
    'pinkishbrown': 'B17261',
    'pinkishgrey': 'C8ACA9',
    'pinkishorange': 'FF7243',
    'pinkishpurple': 'D648D7',
    'pinkishred': 'F02C54',
    'pinkishtan': 'D99B82',
    'pinkpurple': 'EF1DE7',
    'pinkred': 'F5054F',
    'pissyellow': 'DDD618',
    'pistachio': 'C0FA8B',
    'plum': 'DDA0DD',
    'plumpurple': '4E0550',
    'poisongreen': '4CBB17',
    'dung': '8F7303',
    'mudbrown': '885F01',
    'muddyolive': '6F7C00',
    'powderblue': 'B0E0E6',
    'powderpink': 'FFB2D0',
    'primaryblue': '0804F9',
    'prussianblue': '004577',
    'puce': 'A57E52',
    'sick': 'A5A502',
    'sickbrown': '947706',
    'sicklygreen': '9AAE07',
    'jaundiceyellow': 'C2BE0E',
    'pumpkin': 'E17701',
    'pumpkinorange': 'FB7D07',
    'pureblue': '0203E2',
    'purple': 'A020F0',
    'purpleblue': '5539CC',
    'purplebrown': '6B4141',
    'purplegrey': '866F85',
    'purpleish': '98568D',
    'purpleishblue': '6140EF',
    'purpleishpink': 'CE5DAE',
    'purplepink': 'E03FD8',
    'purplered': '990147',
    'purpley': '8756E4',
    'purpleyblue': '5F34E7',
    'purpleygrey': '947E94',
    'purpleypink': 'C83CB9',
    'putty': 'BEAE8A',
    'racinggreen': '014600',
    'radioactivegreen': '2CFA1F',
    'raspberry': 'B00149',
    'rawsienna': '9A6200',
    'rawumber': 'A75E09',
    'reallylightblue': 'D4FFFF',
    'rebeccapurple': '663399',
    'red': 'FF0000',
    'redbrown': '8B2E16',
    'reddish': 'C44240',
    'reddishbrown': '7F2B0A',
    'reddishgrey': '997570',
    'reddishorange': 'F8481C',
    'reddishpink': 'FE2C54',
    'reddishpurple': '910951',
    'redorange': 'FD3C06',
    'redpink': 'FA2A55',
    'richblue': '010067',
    'richpurple': '720058',
    'robinsegg': '87E0D3',
    'robinseggblue': '89D8D3',
    'rose': 'CF6275',
    'rosepink': 'F7879A',
    'rosered': 'BE013C',
    'rosybrown': 'BC8F8F',
    'royalblue': '4169E1',
    'royalpurple': '4B006E',
    'ruby': 'CA0147',
    'rust': 'A83C09',
    'rustbrown': '8B3103',
    'rustorange': 'C45508',
    'rustred': 'AA2704',
    'rustyorange': 'CD5909',
    'rustyred': 'AF2F0D',
    'saddlebrown': '8B4513',
    'saffron': 'FEB209',
    'sage': '87AE73',
    'sagegreen': '88B378',
    'salmon': 'FA8072',
    'salmonpink': 'FE7B7C',
    'sand': 'E2CA76',
    'sandbrown': 'C1A674',
    'sandstone': 'C9AE71',
    'sandy': 'F1DA7A',
    'sandybrown': 'F4A460',
    'sandyyellow': 'FDEE73',
    'sapgreen': '5C8B15',
    'sapphire': '2138AB',
    'scarlet': 'BE0119',
    'sea': '3C9992',
    'seablue': '047495',
    'seafoam': '80F9AD',
    'seafoamblue': '78D1B6',
    'seafoamgreen': '7AF9AD',
    'seagreen': '2E8B57',
    'seaweed': '18D17B',
    'seaweedgreen': '35AD6B',
    'sepia': '985E2B',
    'shamrock': '01B44C',
    'shamrockgreen': '02C14D',
    'darkbrown': '7F5F00',
    'mildewgreen': '758000',
    'shockingpink': 'FE02A2',
    'sicklygreen': '94B21C',
    'sicklyyellow': 'D7E701',
    'sienna': 'A0522D',
    'silver': 'C0C0C0',
    'sky': '82CAFC',
    'skyblue': '87CEEB',
    'slate': '516572',
    'slateblue': '6A5ACD',
    'slategray': '708090',
    'slategreen': '658D6D',
    'slategrey': '59656B',
    'slimegreen': '99CC04',
    'mucus': 'ACBB0D',
    'mucusgreen': '9DC100',
    'snow': 'FFFAFA',
    'softblue': '6488EA',
    'softgreen': '6FC276',
    'softpink': 'FDB0C0',
    'softpurple': 'A66FB5',
    'spearmint': '1EF876',
    'springgreen': '00FF7F',
    'spruce': '0A5F38',
    'squash': 'F2AB15',
    'steel': '738595',
    'steelblue': '4682B4',
    'steelgrey': '6F7378',
    'stone': 'ADA587',
    'stormyblue': '507B9C',
    'strawberry': 'FB2943',
    'strongblue': '0C06F7',
    'strongpink': 'FF0789',
    'sunflower': 'FFC512',
    'sunfloweryellow': 'FFDA03',
    'sunnyyellow': 'FFF917',
    'sunshineyellow': 'FFFD37',
    'swamp': '698339',
    'swampgreen': '748500',
    'tan': 'D2B48C',
    'tanbrown': 'A67B5B',
    'tangerine': 'FF9408',
    'tangreen': 'A9BE70',
    'taupe': 'AB9A8A',
    'tea': '65AB7C',
    'teagreen': 'BDF8A3',
    'teal': '008080',
    'tealblue': '01889F',
    'tealgreen': '25A36F',
    'terracota': 'CB6843',
    'terracotta': 'C9643B',
    'thistle': 'D8BFD8',
    'tiffanyblue': '7BF2DA',
    'tomato': 'FF6347',
    'tomatored': 'EC2D01',
    'topaz': '13BBAF',
    'toxicgreen': '61DE2A',
    'treegreen': '2A7E19',
    'trueblue': '010FCC',
    'turquoise': '40E0D0',
    'turquoiseblue': '06B1C4',
    'turquoisegreen': '04F489',
    'turtlegreen': '75B84F',
    'twilightblue': '0A437A',
    'uglybrown': '7D7103',
    'uglygreen': '7A9703',
    'uglypink': 'CD7584',
    'uglypurple': 'A442A0',
    'uglyyellow': 'D0C101',
    'ultramarine': '2000B1',
    'ultramarineblue': '1805DB',
    'umber': 'B26400',
    'velvet': '750851',
    'vermillion': 'F4320C',
    'verydarkblue': '000133',
    'verydarkbrown': '1D0200',
    'verydarkgreen': '062E03',
    'verydarkpurple': '2A0134',
    'verylightblue': 'D5FFFF',
    'verylightgreen': 'D1FFBD',
    'verylightpink': 'FFF4F2',
    'verylightpurple': 'F6CEFE',
    'verypalegreen': 'CFFDBC',
    'vibrantgreen': '0ADD08',
    'violet': 'EE82EE',
    'violetblue': '510AC9',
    'violetpink': 'FB55F1',
    'violetred': 'D02090',
    'viridian': '3F916E',
    'vividgreen': '2FEF10',
    'vividpurple': '9900FA',
    'sickbright': 'A2A415',
    'warmblue': '4B57DB',
    'warmbrown': '964E02',
    'warmgrey': '978A84',
    'warmpink': 'FB5581',
    'warmpurple': '952E8F',
    'washedoutgreen': 'BCF5A6',
    'waterblue': '0E87CC',
    'watermelon': 'FD4659',
    'weirdgreen': '3AE57F',
    'wheat': 'F5DEB3',
    'white': 'FFFFFF',
    'whitesmoke': 'F5F5F5',
    'windowsblue': '3778BF',
    'wine': '80013F',
    'winered': '900538',
    'wintergreen': '20F986',
    'wisteria': 'A875D4',
    'yellow': 'FFFF00',
    'yellowbrown': 'B79400',
    'yellowgreen': '9ACD32',
    'yellowish': 'FAEE66',
    'yellowishbrown': '9B7A01',
    'yellowishgreen': 'B0DD16',
    'yellowishorange': 'FFAB0F',
    'yellowishtan': 'FCFC81',
    'yellowochre': 'CB9D06',
    'yelloworange': 'FCB001',
    'yellowybrown': 'AE8B0C',
    'yellowygreen': 'BFF128'
}
