# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.auth_provider import AuthProvider
from ..types.auth_provider_connection import AuthProviderConnection
from ..types.config_values import ConfigValues
from .raw_client import AsyncRawAuthProvidersClient, RawAuthProvidersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuthProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthProvidersClient
        """
        return self._raw_client

    def connect_or_update_auth_provider(
        self,
        *,
        name: str,
        short_name: str,
        readable_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        auth_fields: typing.Optional[ConfigValues] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuthProviderConnection:
        """
        Create or update an auth provider connection.

        If a connection for this auth provider already exists for the organization,
        it will be updated with the new credentials and fields.
        If no connection exists, a new one will be created.

        Args:
        -----
            db: The database session
            ctx: The current authentication context
            auth_provider_connection_in: The auth provider connection data

        Returns:
        --------
            schemas.AuthProviderConnection: The created or updated connection

        Parameters
        ----------
        name : str
            Human-readable name for this auth provider connection

        short_name : str
            Technical identifier of the auth provider

        readable_id : typing.Optional[str]
            URL-safe unique identifier for the connection. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the connection name with a random suffix for uniqueness (e.g., 'composio-connection-ab123').

        description : typing.Optional[str]
            Optional detailed description of what this auth provider connection provides.

        auth_fields : typing.Optional[ConfigValues]
            Authentication credentials required to access the auth provider. The required fields vary by auth provider type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthProviderConnection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.auth_providers.connect_or_update_auth_provider(
            name="My Composio Connection",
            description="My Composio Connection",
            short_name="composio",
            auth_fields={"api_key": "comp_1234567890abcdef"},
        )
        """
        _response = self._raw_client.connect_or_update_auth_provider(
            name=name,
            short_name=short_name,
            readable_id=readable_id,
            description=description,
            auth_fields=auth_fields,
            request_options=request_options,
        )
        return _response.data

    def get_auth_provider(
        self, short_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthProvider:
        """
        Get details of a specific auth provider.

        Args:
        -----
            db: The database session
            short_name: The short name of the auth provider
            ctx: The current authentication context

        Returns:
        --------
            schemas.AuthProvider: The auth provider details

        Parameters
        ----------
        short_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthProvider
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.auth_providers.get_auth_provider(
            short_name="short_name",
        )
        """
        _response = self._raw_client.get_auth_provider(short_name, request_options=request_options)
        return _response.data


class AsyncAuthProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthProvidersClient
        """
        return self._raw_client

    async def connect_or_update_auth_provider(
        self,
        *,
        name: str,
        short_name: str,
        readable_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        auth_fields: typing.Optional[ConfigValues] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuthProviderConnection:
        """
        Create or update an auth provider connection.

        If a connection for this auth provider already exists for the organization,
        it will be updated with the new credentials and fields.
        If no connection exists, a new one will be created.

        Args:
        -----
            db: The database session
            ctx: The current authentication context
            auth_provider_connection_in: The auth provider connection data

        Returns:
        --------
            schemas.AuthProviderConnection: The created or updated connection

        Parameters
        ----------
        name : str
            Human-readable name for this auth provider connection

        short_name : str
            Technical identifier of the auth provider

        readable_id : typing.Optional[str]
            URL-safe unique identifier for the connection. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the connection name with a random suffix for uniqueness (e.g., 'composio-connection-ab123').

        description : typing.Optional[str]
            Optional detailed description of what this auth provider connection provides.

        auth_fields : typing.Optional[ConfigValues]
            Authentication credentials required to access the auth provider. The required fields vary by auth provider type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthProviderConnection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.auth_providers.connect_or_update_auth_provider(
                name="My Composio Connection",
                description="My Composio Connection",
                short_name="composio",
                auth_fields={"api_key": "comp_1234567890abcdef"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.connect_or_update_auth_provider(
            name=name,
            short_name=short_name,
            readable_id=readable_id,
            description=description,
            auth_fields=auth_fields,
            request_options=request_options,
        )
        return _response.data

    async def get_auth_provider(
        self, short_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthProvider:
        """
        Get details of a specific auth provider.

        Args:
        -----
            db: The database session
            short_name: The short name of the auth provider
            ctx: The current authentication context

        Returns:
        --------
            schemas.AuthProvider: The auth provider details

        Parameters
        ----------
        short_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthProvider
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.auth_providers.get_auth_provider(
                short_name="short_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_auth_provider(short_name, request_options=request_options)
        return _response.data
