# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.auth_provider import AuthProvider
from ..types.auth_provider_connection import AuthProviderConnection
from ..types.config_values import ConfigValues
from ..types.http_validation_error import HttpValidationError

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAuthProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def connect_or_update_auth_provider(
        self,
        *,
        name: str,
        short_name: str,
        readable_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        auth_fields: typing.Optional[ConfigValues] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AuthProviderConnection]:
        """
        Create or update an auth provider connection.

        If a connection for this auth provider already exists for the organization,
        it will be updated with the new credentials and fields.
        If no connection exists, a new one will be created.

        Args:
        -----
            db: The database session
            ctx: The current authentication context
            auth_provider_connection_in: The auth provider connection data

        Returns:
        --------
            schemas.AuthProviderConnection: The created or updated connection

        Parameters
        ----------
        name : str
            Human-readable name for this auth provider connection

        short_name : str
            Technical identifier of the auth provider

        readable_id : typing.Optional[str]
            URL-safe unique identifier for the connection. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the connection name with a random suffix for uniqueness (e.g., 'composio-connection-ab123').

        description : typing.Optional[str]
            Optional detailed description of what this auth provider connection provides.

        auth_fields : typing.Optional[ConfigValues]
            Authentication credentials required to access the auth provider. The required fields vary by auth provider type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuthProviderConnection]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "auth-providers/connect",
            method="PUT",
            json={
                "name": name,
                "readable_id": readable_id,
                "description": description,
                "short_name": short_name,
                "auth_fields": auth_fields,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthProviderConnection,
                    parse_obj_as(
                        type_=AuthProviderConnection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_auth_provider(
        self, short_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[AuthProvider]:
        """
        Get details of a specific auth provider.

        Args:
        -----
            db: The database session
            short_name: The short name of the auth provider
            ctx: The current authentication context

        Returns:
        --------
            schemas.AuthProvider: The auth provider details

        Parameters
        ----------
        short_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuthProvider]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"auth-providers/detail/{jsonable_encoder(short_name)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthProvider,
                    parse_obj_as(
                        type_=AuthProvider,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAuthProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def connect_or_update_auth_provider(
        self,
        *,
        name: str,
        short_name: str,
        readable_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        auth_fields: typing.Optional[ConfigValues] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AuthProviderConnection]:
        """
        Create or update an auth provider connection.

        If a connection for this auth provider already exists for the organization,
        it will be updated with the new credentials and fields.
        If no connection exists, a new one will be created.

        Args:
        -----
            db: The database session
            ctx: The current authentication context
            auth_provider_connection_in: The auth provider connection data

        Returns:
        --------
            schemas.AuthProviderConnection: The created or updated connection

        Parameters
        ----------
        name : str
            Human-readable name for this auth provider connection

        short_name : str
            Technical identifier of the auth provider

        readable_id : typing.Optional[str]
            URL-safe unique identifier for the connection. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the connection name with a random suffix for uniqueness (e.g., 'composio-connection-ab123').

        description : typing.Optional[str]
            Optional detailed description of what this auth provider connection provides.

        auth_fields : typing.Optional[ConfigValues]
            Authentication credentials required to access the auth provider. The required fields vary by auth provider type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuthProviderConnection]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "auth-providers/connect",
            method="PUT",
            json={
                "name": name,
                "readable_id": readable_id,
                "description": description,
                "short_name": short_name,
                "auth_fields": auth_fields,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthProviderConnection,
                    parse_obj_as(
                        type_=AuthProviderConnection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_auth_provider(
        self, short_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[AuthProvider]:
        """
        Get details of a specific auth provider.

        Args:
        -----
            db: The database session
            short_name: The short name of the auth provider
            ctx: The current authentication context

        Returns:
        --------
            schemas.AuthProvider: The auth provider details

        Parameters
        ----------
        short_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuthProvider]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"auth-providers/detail/{jsonable_encoder(short_name)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthProvider,
                    parse_obj_as(
                        type_=AuthProvider,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
