# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .config_values import ConfigValues


class SourceConnectionCreateContinuous(UniversalBaseModel):
    """
    Schema for creating a continuously syncing source connection (BETA).

    This endpoint creates a source connection that stays continuously in sync with your
    data source. Your data will be automatically synchronized every minute, ensuring it's
    always up-to-date without any manual intervention or sync management.
    """

    name: str = pydantic.Field()
    """
    Human-readable name for the source connection. This helps you identify the connection in the UI and should clearly describe what data it connects to.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional detailed description of what this source connection provides. Use this to document the purpose, data types, or any special considerations for this connection.
    """

    config_fields: typing.Optional[ConfigValues] = pydantic.Field(default=None)
    """
    Source-specific configuration parameters required for data extraction. These vary by source type and control how data is retrieved (e.g., database queries, API filters, file paths). Check the documentation of a specific source (for example [Github](https://docs.airweave.ai/docs/connectors/github)) to see what is required.
    """

    short_name: str = pydantic.Field()
    """
    Technical identifier of the source type that determines which connector to use for data synchronization.
    """

    collection: typing.Optional[str] = pydantic.Field(default=None)
    """
    Readable ID of the collection where synced data will be stored. If not provided, a new collection will be automatically created.
    """

    enable_daily_cleanup: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to create a daily forced full sync with entity cleanup. Defaults to true for resilience; set to false to rely solely on incremental changes.
    """

    auth_fields: typing.Optional[ConfigValues] = pydantic.Field(default=None)
    """
    Authentication credentials required to access the data source. The required fields vary by source type. Check the documentation of a specific source (for example [Github](https://docs.airweave.ai/docs/connectors/github)) to see what is required.
    """

    auth_provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique readable ID of a connected auth provider to use for authentication instead of providing auth_fields directly.
    """

    auth_provider_config: typing.Optional[ConfigValues] = pydantic.Field(default=None)
    """
    Configuration for the auth provider when using auth_provider field.
    """

    cursor_field: typing.Optional[str] = pydantic.Field(default=None)
    """
    Specify which field in the entity should be used as the cursor for incremental syncs. This field must contain a timestamp or incrementing value that indicates when records were last modified. Required for sources without predefined entities (e.g., databases). If not specified, the source's default cursor field will be used if available.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
