# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SourceConnectionMakeContinuous(UniversalBaseModel):
    """
    Schema for converting an existing source connection to continuous (BETA).
    """

    cursor_field: typing.Optional[str] = pydantic.Field(default=None)
    """
    Specify which field in the entity should be used as the cursor for incremental syncs. If omitted, the source's default cursor field will be used if available. Required for sources without a default (e.g., PostgreSQL).
    """

    enable_daily_cleanup: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to create a daily forced full sync with entity cleanup. This helps remove orphaned entities that incremental syncs cannot detect.
    """

    run_initial_sync: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to immediately trigger a sync job after enabling continuous mode. If no cursor data exists yet, this initial run will perform a full sync.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
