# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/stable/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

import os
import sys
sys.path.insert(0, os.path.abspath('../../src/'))
sys.path.insert(0, os.path.abspath('../../src/MicroStructPy/'))

import sphinx_gallery

import microstructpy


# -- Project information -----------------------------------------------------

project = 'MicroStructPy'
copyright = '2019, Georgia Tech Research Corporation'
author = 'Kenneth Hart'

# The short X.Y version
version = ''.join(microstructpy.__version__.split('.')[:2])
# The full version, including alpha/beta/rc tags
release = microstructpy.__version__


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.napoleon',
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode',
    'sphinx_gallery.gen_gallery',
]

intersphinx_mapping = {
    'matplotlib': ('https://matplotlib.org/', None),
    'meshpy': ('https://documen.tician.de/meshpy/', None),
    'numpy': ('http://docs.scipy.org/doc/numpy/', None),
    'python': ('https://docs.python.org/3', None),
    'scipy': ('https://docs.scipy.org/doc/scipy/reference/', None)
}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ['auto_examples/*', 'sphinx_gallery/*']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# Mock imports
autodoc_mock_imports = [
    'aabbtree',
    'matplotlib',
    'meshpy',
    'mpl_toolkits',
    'numpy',
    'pyquaternion',
    'pyvoro',
    'pyvtk',
    'scipy',
    'sphinx-gallery',
    'xmltodict']
autodoc_member_order = 'groupwise'

sphinx_gallery_conf = {
    'examples_dirs': [
        'sphinx_gallery',
        'sphinx_gallery/geometry',
        ],
    'gallery_dirs': [
        'auto_examples/demos',
        'auto_examples/geometry',
        ],
}

# Numbering figures, tables, listings, etc
numfig = True
numfig_secnum_depth = 1



# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

html_theme = 'alabaster'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    'logo': 'logo/pad_logo.svg',
    'logo_name': True,
    'sidebar_width': '230px',
    'touch_icon': 'logo/logo.svg',
    'description': 'Microstructure modeling, mesh generation, analysis, and visualization.',
    'analytics_id': 'UA-147258715-1',
    'code_font_size': '12.5px',
}

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = 'MicroStructPy'

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = 'MSP'

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = '_static/logo.svg'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = '_static/favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
html_domain_indices = False

# If false, no index is generated.
html_use_index = False

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = False

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'MicroStructPydoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    'preamble': '\n'.join(['\\usepackage{subfig}',
                           '\\numberwithin{figure}{chapter}',
                           '\\numberwithin{table}{chapter}',
                           '\\numberwithin{equation}{chapter}'
                           ]),

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

latex_logo = '_static/logo/pad_logo.png'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    ('contents', 'MicroStructPy.tex', 'MicroStructPy Documentation',
     'Kenneth Hart', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'microstructpy', 'MicroStructPy Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'MicroStructPy', 'MicroStructPy Documentation',
     author, 'MicroStructPy',
     'Microstructure modeling, mesh generation, analysis, and visualization.',
     'Miscellaneous'),
]
