# Usage #

`ethdbg` is the CLI EVM debugger installed with the `ethpwn` package.
Before starting to play with `ethdbg` you need to make a few steps.

## 📝 Config File

There are two main configuration files that can be used to customize the behavior of `ethdbg`.

#### ♦️ config.json

The `ethpwn` config file is located at `~/.config/ethpwn/config.json` and includes configuration for  the behavior of `ethdbg` while debugging.

Refer to the [ethpwn configuration docs](/ethpwn/ethpwn/global_state/#configuration) for the general structure of the configuration file.

If you did not do so already, you can create a configuration file by running:

```bash
ethpwn config create
```

Under the key `dbg` in the main configuration, the following options are available:

| Option String       | Option Summary | Default |
|---------------------|----------------|----------|
|`show_opcodes_desc`  | whether to display the description of the EVM opcodes in the disassembly | True |
|`stop_on_returns`    | whether you want `ethdbg` to always stop at RETURN opcodes | False |
|`stop_on_reverts`    | whether you want `ethdbg` to always stop at REVERT opcodes | True |
|`hide_sstores`       | whether you want to hide the sstores issued for the current account in the context view | False |
|`hide_sloads`        | whether you want to hide the sloads issued for the current account in the context view | False |
|`context_layout`     | The layout of the views to display in the context, for details see [Context Layout](/ethpwn/ethdbg/commands/context/) | "source,metadata,status,disass,stack,callstack" |
|`source_view_cutoff` | the maximum amount of source code lines that are displayed | None |

Here are two possible configuration files:

```json
{
  "default_network": "mainnet",
  "default_node_urls": {
    "mainnet": "<YOUR_INFURA_MAINNET_RPC_URL>",
  },
  "credentials": {
    "etherscan": "<OPTIONAL_ETHERSCAN_API>"
  },
  "dbg": {
    "show_opcodes_desc": false,
    "stop_on_returns": false,
    "stop_on_reverts": true,
    "hide_sstores": true,
    "hide_sloads": true,
    "hide_source_view": false,
    "source_view_cutoff": 20
  }
}
```

```json
{
  "default_network": "mainnet",
  "default_node_urls": {
    "mainnet": "<YOUR_INFURA_MAINNET_RPC_URL>",
    "sepolia": "<YOUR_INFURA_SEPOLIA_RPC_URL>",
  },
  "credentials": {
    "etherscan": "<OPTIONAL_ETHERSCAN_API>"
  },
  "dbg": {
    "hide_sloads": true,
    "source_view_cutoff": 20
  }
}
```

#### ♦️ wallets.json
This file is located at `~/.config/ethpwn/wallets.json` and contains the configuration for the accounts that you want
to use when debugging transactions with `ethdbg`.
An example of such a configuration is the following:

```json
[
{"address": "0x1a5984F43dAD95a5121b1b30B9190d619d84d21C",
"private_key": "0x2838aa1e473a046941d3ee4481396b9c54c944a6b6321e489b654554125f374b",
"network": "mainnet",
"name": "my-test-wallet",
"description": "Default wallet generated by ethpwn on 2023-07-09 13:12:05.184774"}
]
```

| 🛑 Warning                               |
|------------------------------------------|
| ***!!!!! DO NOT use accounts and private keys that hold valuable assets in this config file! This file is NOT protected in any way. Putting sensitive private keys here might lead to exposing them in the clear and can cause the loss of funds on the related account if someone can steal them. ALWAYS use test accounts!***|

`ethdbg` will generate a default wallet with a random account if you do not specify one and will use it for signing transactions.
Conversely, if you have multiple accounts such as:

```json
[
{"address": "0x1a5984F43dAD95a5121b1b30B9190d619d84d21C",
"private_key": "0x2838aa1e473a046941d3ee4481396b9c54c944a6b6321e489b654554125f374b",
"network": "mainnet",
"name": "my-test-wallet",
"description": "Default wallet generated by ethpwn on 2023-07-09 13:12:05.184774"},

{"address": "0x2c076bc7090686fad57814965D53722CFC3e0B13",
"private_key": "0x51f300465cba08ec2a83d58223824a5b7902c76d64920a5ad90b5bcfd24c6565",
"network": "sepolia",
"name": "my-sepolia-wallet",
"description": "Default wallet generated by ethpwn on 2023-07-15 10:49:19.516119"}
]
```

You can select the wallet you want to use by using the `--wallet` command line option and the "name" of the wallet. e.g.:

```bash
ethdbg --target 0xeC55Bf7E10b6594874554BAd1B461214Cab413d4 --calldata cbd8c06a00000000000000 --node-url "<YOUR_INFURA_MAINNET_RPC_URL>" --block 11469711 --wallet my-sepolia-wallet
```

## ⚡️ Command Line Arguments

`ethdbg` supports different command line arguments that can customize your analysis.

The following options can be used, for instance, to simulate sending a new transaction to a `target` smart contract with custom `calldata`, or, replaying a given transaction (`txid`) with a different `sender` and more!

<style>
tr:nth-child(even) {
  background-color: #C8D8EF!important;
}
</style>

| Option String      | Required | Default | Option Summary |
|--------------------|----------|---------|----------------|
| --txid         | False    | None    | Instantiate ethdbg to replay an existing transaction. |
| --full-context | False    | False   | Given a transaction `T` that you want to replay, whether or not you want to apply the transactions preceding `T` in the block (i.e., if the execution depends on the execution of the previous ones!). |
| --sender       | False    | The original sender in the transaction (if `txid` is specified), otherwise, the sender in your wallet.json | Allows you to set or overwrite the address of the sender in the debugged transaction. |
| --gas       | False    | The original gas used for  the transaction (if `txid` is specified), otherwise, estimated by `ethdbg` | Allows you to set or overwrite the gas used for the debugged transaction. |
| --balance      | False    | Balance of the original sender in the transaction (if `txid` is specified), otherwise, a placeholder value of 100000000 ETH. | Overwrite or set the balance of the sender wallet of the target transaction. |
| --node-url     | False    | Value in the ethdbg_config file, or, `127.0.0.1:8546`. | URL of the RPC node you want to use. |
| --target       | False    | The original contract address (if `txid` is specified) | Target smart contract address when trying to send a new transaction. |
| --block        | False    | The original block (if `txid` is specified), otherwise the `latest` block. | Block at which you want to simulate the new transaction (the transaction will be simulated as executing at the beginning of the block). |
| --calldata     | False    | The original calldata of the transaction (if `txid` is specified)  | Calldata you want to use for a new transaction |
| --wallet       | False    | The default wallet in the `ethpwn` config | Name or address of the wallet in the configuration you want to use |
| --shellcode    | False    | None | EVM bytecode that we want to execute on-the-fly in ethdbg |
| --value    | False    | None | The original value sent with the transaction (if `txid` is specified), otherwise 0 | Set the amount of ETH to send with this transaction |

## 🚀 Examples Usage

#### ♦️ Replay an existing transaction on-chain as-is.
```bash
ethdbg --txid 0x168f7f3acd40e0632e11b208c40ecc3c790bcb46c131f0207892859871ec3d3e
```

#### ♦️ Replay an existing transaction on-chain as-is, with full context.
```bash
ethdbg --full-context --txid 0x168f7f3acd40e0632e11b208c40ecc3c790bcb46c131f0207892859871ec3d3e
```

#### ♦️ Replay an existing transaction on-chain and change the sender.
```bash
ethdbg --sender 0x1a5984F43dAD95a5121b1b30B9190d619d84d21C --txid 0x168f7f3acd40e0632e11b208c40ecc3c790bcb46c131f0207892859871ec3d3e
```

| ❗️ Note                               |
|------------------------------------------|
| The chosen sender must have enough funds to execute the transaction. You can use `--balance` to edit this value. |

```bash
ethdbg --balance 1000000000000000 --sender 0x1a5984F43dAD95a5121b1b30B9190d619d84d21C --txid 0x168f7f3acd40e0632e11b208c40ecc3c790bcb46c131f0207892859871ec3d3e
```

#### ♦️ Replay an existing transaction at a different block.
```bash
ethdbg --block 17700180 --txid 0x168f7f3acd40e0632e11b208c40ecc3c790bcb46c131f0207892859871ec3d3e
```

#### ♦️ Send a new transaction to target contract with custom calldata.
```bash
ethdbg --calldata cbd8c06a00000000000000 --target 0xeC55Bf7E10b6594874554BAd1B461214Cab413d4
```

#### ♦️ Send a new transaction to target contract with custom calldata at custom block.
```bash
ethdbg --block 11469711 --calldata cbd8c06a00000000000000 --target 0xeC55Bf7E10b6594874554BAd1B461214Cab413d4
```

