#!/usr/bin/env python3

import sys
from ethpwn import *
from time import sleep

import argparse

parser = argparse.ArgumentParser()
parser.add_argument('node_url', type=str, help="The node to connect to (e.g. https://eth-sepolia.g.alchemy.com/v2/<key>)")
parser.add_argument('exploit_contract_source', type=str, help="The path to the exploit contract source")
parser.add_argument('instance_addr', type=str, help="The address of the target instance")
parser.add_argument('--force', action='store_true', help="Force the exploit even if estimage_gas says it will fail")
parser.add_argument('--value', type=parse_wei, default=0, help="Value to send with the exploit transaction")

ARGS = parser.parse_args()

context.log_level = 'DEBUG'

context.connect_http(sys.argv[1])


CONTRACT_METADATA.compile_solidity_files([ARGS.exploit_contract_source])

with CONTRACT_METADATA['Exploit'].deploy_destructible(ARGS.instance_addr, force=ARGS.force) as (_, target):
    print(f"Exploit contract is at {target.address}")

    sleep(1)

    transact(target.functions.exploit(), value=ARGS.value, force=ARGS.force)
