// SPDX-License-Identifier: GPL-3.0

pragma solidity ^0.8.0;

contract Destructible {
    address owner_address = address(0);

    constructor() payable {
        owner_address = msg.sender;
    }

    function destroy() public {
        if (owner_address == address(0)) {
            payable(msg.sender).transfer(address(this).balance);
        }
        else {
            payable(owner_address).transfer(address(this).balance);
        }
    }

    function owner() public view returns(address) {
        return owner_address;
    }
}
