from eth_utils import keccak

WETH_ADDRESS    = '0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2'

USDC_ADDRESS    = '0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48'
USDC_DECIMALS   = 6
TETHER_ADDRESS  = '0xdAC17F958D2ee523a2206206994597C13D831ec7'
TETHER_DECIMALS = 6
BUSD_ADDRESS    = '0x4Fabb145d64652a948d72533023f6E7A623C7C53'
BUSD_DECIMALS   = 18
DAI_ADDRESS     = '0x6B175474E89094C44Da98b954EedeAC495271d0F'
DAI_DECIMALS    = 18

STABLECOINS = [
    (USDC_ADDRESS, USDC_DECIMALS),
    (TETHER_ADDRESS, TETHER_DECIMALS),
    (BUSD_ADDRESS, BUSD_DECIMALS),
    (DAI_ADDRESS, DAI_DECIMALS),
]

DECIMALS_METHOD_SELECTOR = keccak(b'decimals()')[:4]
