"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Annotations = exports.DISABLE_STACK_TRACE_IN_METADATA = exports.AnnotationMetadataEntryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var AnnotationMetadataEntryType;
(function (AnnotationMetadataEntryType) {
    AnnotationMetadataEntryType["INFO"] = "@cdktf/info";
    AnnotationMetadataEntryType["WARN"] = "@cdktf/warn";
    AnnotationMetadataEntryType["ERROR"] = "@cdktf/error";
})(AnnotationMetadataEntryType = exports.AnnotationMetadataEntryType || (exports.AnnotationMetadataEntryType = {}));
exports.DISABLE_STACK_TRACE_IN_METADATA = "@cdktf/disable_stack_trace_in_metadata";
/**
 * Includes API for attaching annotations such as warning messages to constructs.
 */
class Annotations {
    constructor(scope) {
        this.scope = scope;
        const disableTrace = scope.node.tryGetContext(exports.DISABLE_STACK_TRACE_IN_METADATA) || false;
        this.stackTraces = !disableTrace;
    }
    /**
     * Returns the annotations API for a construct scope.
     * @param scope The scope
     */
    static of(scope) {
        return new Annotations(scope);
    }
    /**
     * Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized.
     * In a future release the CLI might introduce a --strict flag which
     * will then fail the synthesis if it encounters a warning.
     *
     * @param message The warning message.
     */
    addWarning(message) {
        this.addMessage(AnnotationMetadataEntryType.WARN, message);
    }
    /**
     * Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     */
    addInfo(message) {
        this.addMessage(AnnotationMetadataEntryType.INFO, message);
    }
    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * The toolkit will fail synthesis when errors are reported.
     * @param message The error message.
     */
    addError(message) {
        this.addMessage(AnnotationMetadataEntryType.ERROR, message);
    }
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    addMessage(level, message) {
        this.scope.node.addMetadata(level, message, {
            stackTrace: this.stackTraces,
        });
    }
}
exports.Annotations = Annotations;
_a = JSII_RTTI_SYMBOL_1;
Annotations[_a] = { fqn: "cdktf.Annotations", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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