import { Construct, IConstruct } from "constructs";
import { Manifest } from "./manifest";
import { TerraformStack } from "./terraform-stack";
export declare const CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
export interface AppOptions {
    /**
     * The directory to output Terraform resources.
     *
     * @default - CDKTF_OUTDIR if defined, otherwise "cdktf.out"
     */
    readonly outdir?: string;
    readonly stackTraces?: boolean;
    /**
     * Additional context values for the application.
     *
     * Context set by the CLI or the `context` key in `cdktf.json` has precedence.
     *
     * Context can be read from any construct using `node.getContext(key)`.
     *
     * @default - no additional context
     */
    readonly context?: {
        [key: string]: any;
    };
    /**
     * Whether to skip the validation during synthesis of the app
     *
     * @default - false
     */
    readonly skipValidation?: boolean;
}
/**
 * Represents a cdktf application.
 */
export declare class App extends Construct {
    /**
     * The output directory into which resources will be synthesized.
     */
    readonly outdir: string;
    /**
     * The stack which will be synthesized. If not set, all stacks will be synthesized.
     */
    readonly targetStackId: string | undefined;
    readonly manifest: Manifest;
    /**
     * Whether to skip the validation during synthesis of the app
     */
    readonly skipValidation?: boolean;
    /**
     * Defines an app
     * @param options configuration options
     */
    constructor(options?: AppOptions);
    static isApp(x: any): x is App;
    static of(construct: IConstruct): App;
    /**
     * Synthesizes all resources to the output directory
     */
    synth(): void;
    /**
     * Creates a reference from one stack to another, invoked on prepareStack since it creates extra resources
     */
    crossStackReference(fromStack: TerraformStack, toStack: TerraformStack, identifier: string): string;
    private loadContext;
}
