"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = exports.CONTEXT_ENV = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const fs = require("fs");
const package_json_1 = require("../package.json");
const annotations_1 = require("./annotations");
const manifest_1 = require("./manifest");
const terraform_stack_1 = require("./terraform-stack");
const APP_SYMBOL = Symbol.for("cdktf/App");
exports.CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
/**
 * Represents a cdktf application.
 */
class App extends constructs_1.Construct {
    /**
     * Defines an app
     * @param options configuration options
     */
    constructor(options = {}) {
        var _b, _c;
        super(undefined, "");
        Object.defineProperty(this, APP_SYMBOL, { value: true });
        this.outdir = (_c = (_b = process.env.CDKTF_OUTDIR) !== null && _b !== void 0 ? _b : options.outdir) !== null && _c !== void 0 ? _c : "cdktf.out";
        this.targetStackId = process.env.CDKTF_TARGET_STACK_ID;
        this.skipValidation = options.skipValidation;
        this.loadContext(options.context);
        const node = this.node;
        if (options.stackTraces === false) {
            node.setContext(annotations_1.DISABLE_STACK_TRACE_IN_METADATA, true);
        }
        node.setContext("cdktfVersion", package_json_1.version);
        if (!fs.existsSync(this.outdir)) {
            fs.mkdirSync(this.outdir);
        }
        this.manifest = new manifest_1.Manifest(package_json_1.version, this.outdir);
    }
    static isApp(x) {
        return x !== null && typeof x === "object" && APP_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (App.isApp(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No app could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    /**
     * Synthesizes all resources to the output directory
     */
    synth() {
        const session = {
            outdir: this.outdir,
            skipValidation: this.skipValidation,
            manifest: this.manifest,
        };
        const stacks = this.node
            .findAll()
            .filter((c) => c instanceof terraform_stack_1.TerraformStack);
        stacks.forEach((stack) => stack.prepareStack());
        stacks.forEach((stack) => stack.synthesizer.synthesize(session));
        this.manifest.writeToFile();
    }
    /**
     * Creates a reference from one stack to another, invoked on prepareStack since it creates extra resources
     */
    crossStackReference(fromStack, toStack, identifier) {
        toStack.addDependency(fromStack);
        const outputId = fromStack.registerOutgoingCrossStackReference(identifier).friendlyUniqueId;
        const remoteState = toStack.registerIncomingCrossStackReference(fromStack);
        return remoteState.getString(outputId);
    }
    loadContext(defaults = {}) {
        const node = this.node;
        // prime with defaults passed through constructor
        for (const [k, v] of Object.entries(defaults)) {
            node.setContext(k, v);
        }
        // read from environment
        const contextJson = process.env[exports.CONTEXT_ENV];
        const contextFromEnvironment = contextJson ? JSON.parse(contextJson) : {};
        for (const [k, v] of Object.entries(contextFromEnvironment)) {
            node.setContext(k, v);
        }
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "cdktf.App", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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