import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class ArtifactoryBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: ArtifactoryBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateArtifactory extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateArtifactoryConfig);
}
export interface ArtifactoryBackendProps {
    readonly username: string;
    readonly password: string;
    readonly url: string;
    readonly repo: string;
    readonly subpath: string;
}
export interface DataTerraformRemoteStateArtifactoryConfig extends DataTerraformRemoteStateConfig, ArtifactoryBackendProps {
}
