import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class AzurermBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: AzurermBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateAzurerm extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateAzurermConfig);
}
export interface AzurermBackendProps {
    readonly storageAccountName: string;
    readonly containerName: string;
    readonly key: string;
    readonly environment?: string;
    readonly endpoint?: string;
    readonly subscriptionId?: string;
    readonly tenantId?: string;
    readonly msiEndpoint?: string;
    readonly useMsi?: boolean;
    readonly sasToken?: string;
    readonly accessKey?: string;
    readonly resourceGroupName?: string;
    readonly clientId?: string;
    readonly clientSecret?: string;
}
export interface DataTerraformRemoteStateAzurermConfig extends DataTerraformRemoteStateConfig, AzurermBackendProps {
}
