"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateAzurerm = exports.AzurermBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class AzurermBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "azurerm");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateAzurerm(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.AzurermBackend = AzurermBackend;
_a = JSII_RTTI_SYMBOL_1;
AzurermBackend[_a] = { fqn: "cdktf.AzurermBackend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateAzurerm extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "azurerm", config);
    }
}
exports.DataTerraformRemoteStateAzurerm = DataTerraformRemoteStateAzurerm;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateAzurerm[_b] = { fqn: "cdktf.DataTerraformRemoteStateAzurerm", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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