import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class ConsulBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: ConsulBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateConsul extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateConsulConfig);
}
export interface ConsulBackendProps {
    readonly path: string;
    readonly accessToken: string;
    readonly address?: string;
    readonly scheme?: string;
    readonly datacenter?: string;
    readonly httpAuth?: string;
    readonly gzip?: boolean;
    readonly lock?: boolean;
    readonly caFile?: string;
    readonly certFile?: string;
    readonly keyFile?: string;
}
export interface DataTerraformRemoteStateConsulConfig extends DataTerraformRemoteStateConfig, ConsulBackendProps {
}
