import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class CosBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: CosBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateCos extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateCosConfig);
}
export interface CosBackendProps {
    readonly secretId?: string;
    readonly secretKey?: string;
    readonly region?: string;
    readonly bucket: string;
    readonly prefix?: string;
    readonly key?: string;
    readonly encrypt?: boolean;
    readonly acl?: string;
}
export interface DataTerraformRemoteStateCosConfig extends DataTerraformRemoteStateConfig, CosBackendProps {
}
