import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class EtcdBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: EtcdBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateEtcd extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateEtcdConfig);
}
export interface EtcdBackendProps {
    readonly path: string;
    readonly endpoints: string;
    readonly username?: string;
    readonly password?: string;
}
export interface DataTerraformRemoteStateEtcdConfig extends DataTerraformRemoteStateConfig, EtcdBackendProps {
}
