"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateEtcd = exports.EtcdBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class EtcdBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "etcd");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateEtcd(scope, name, this.props);
    }
}
exports.EtcdBackend = EtcdBackend;
_a = JSII_RTTI_SYMBOL_1;
EtcdBackend[_a] = { fqn: "cdktf.EtcdBackend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateEtcd extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "etcd", config);
    }
}
exports.DataTerraformRemoteStateEtcd = DataTerraformRemoteStateEtcd;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateEtcd[_b] = { fqn: "cdktf.DataTerraformRemoteStateEtcd", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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