import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class EtcdV3Backend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: EtcdV3BackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateEtcdV3 extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateEtcdV3Config);
}
export interface EtcdV3BackendProps {
    readonly endpoints: string[];
    readonly username?: string;
    readonly password?: string;
    readonly prefix?: string;
    readonly lock?: boolean;
    readonly cacertPath?: string;
    readonly certPath?: string;
    readonly keyPath?: string;
}
export interface DataTerraformRemoteStateEtcdV3Config extends DataTerraformRemoteStateConfig, EtcdV3BackendProps {
}
