"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateEtcdV3 = exports.EtcdV3Backend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class EtcdV3Backend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "etcdv3");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateEtcdV3(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.EtcdV3Backend = EtcdV3Backend;
_a = JSII_RTTI_SYMBOL_1;
EtcdV3Backend[_a] = { fqn: "cdktf.EtcdV3Backend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateEtcdV3 extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "etcdv3", config);
    }
}
exports.DataTerraformRemoteStateEtcdV3 = DataTerraformRemoteStateEtcdV3;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateEtcdV3[_b] = { fqn: "cdktf.DataTerraformRemoteStateEtcdV3", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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