import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class GcsBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: GcsBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateGcs extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateGcsConfig);
}
export interface GcsBackendProps {
    readonly bucket: string;
    readonly credentials?: string;
    readonly accessToken?: string;
    readonly prefix?: string;
    readonly encryptionKey?: string;
    readonly impersonateServiceAccount?: string;
    readonly impersonateServiceAccountDelegates?: string[];
}
export interface DataTerraformRemoteStateGcsConfig extends DataTerraformRemoteStateConfig, GcsBackendProps {
}
