"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateGcs = exports.GcsBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class GcsBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "gcs");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateGcs(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.GcsBackend = GcsBackend;
_a = JSII_RTTI_SYMBOL_1;
GcsBackend[_a] = { fqn: "cdktf.GcsBackend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateGcs extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "gcs", config);
    }
}
exports.DataTerraformRemoteStateGcs = DataTerraformRemoteStateGcs;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateGcs[_b] = { fqn: "cdktf.DataTerraformRemoteStateGcs", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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