import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class HttpBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: HttpBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateHttp extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateHttpConfig);
}
export interface HttpBackendProps {
    readonly address: string;
    readonly updateMethod?: string;
    readonly lockAddress?: string;
    readonly lockMethod?: string;
    readonly unlockAddress?: string;
    readonly unlockMethod?: string;
    readonly username?: string;
    readonly password?: string;
    readonly skipCertVerification?: boolean;
    readonly retryMax?: number;
    readonly retryWaitMin?: number;
    readonly retryWaitMax?: number;
}
export interface DataTerraformRemoteStateHttpConfig extends DataTerraformRemoteStateConfig, HttpBackendProps {
}
