import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class LocalBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props?: LocalBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateLocal extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateLocalConfig);
}
export interface LocalBackendProps {
    /**
     * Path where the state file is stored.
     * @default - defaults to terraform.${stackId}.tfstate
     */
    readonly path?: string;
    readonly workspaceDir?: string;
}
export interface DataTerraformRemoteStateLocalConfig extends DataTerraformRemoteStateConfig, LocalBackendProps {
}
