"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateLocal = exports.LocalBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
const __1 = require("..");
class LocalBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props = {}) {
        super(scope, "backend", "local");
        const stackId = __1.TerraformStack.of(this).node.id;
        this.props = {
            ...props,
            path: props.path || path.join(process.cwd(), `terraform.${stackId}.tfstate`),
        };
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, fromStack) {
        return new DataTerraformRemoteStateLocal(scope, name, {
            workspaceDir: this.props.workspaceDir,
            path: this.props.path ||
                path.join(process.cwd(), `terraform.${fromStack}.tfstate`),
            workspace: "${terraform.workspace}",
        });
    }
}
exports.LocalBackend = LocalBackend;
_a = JSII_RTTI_SYMBOL_1;
LocalBackend[_a] = { fqn: "cdktf.LocalBackend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateLocal extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "local", config);
    }
}
exports.DataTerraformRemoteStateLocal = DataTerraformRemoteStateLocal;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateLocal[_b] = { fqn: "cdktf.DataTerraformRemoteStateLocal", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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