import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class MantaBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: MantaBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateManta extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateMantaConfig);
}
export interface MantaBackendProps {
    readonly account: string;
    readonly user?: string;
    readonly url?: string;
    readonly keyMaterial?: string;
    readonly keyId: string;
    readonly insecureSkipTlsVerify?: boolean;
    readonly path: string;
    readonly objectName?: string;
}
export interface DataTerraformRemoteStateMantaConfig extends DataTerraformRemoteStateConfig, MantaBackendProps {
}
