"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateManta = exports.MantaBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class MantaBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "manta");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateManta(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.MantaBackend = MantaBackend;
_a = JSII_RTTI_SYMBOL_1;
MantaBackend[_a] = { fqn: "cdktf.MantaBackend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateManta extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "manta", config);
    }
}
exports.DataTerraformRemoteStateManta = DataTerraformRemoteStateManta;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateManta[_b] = { fqn: "cdktf.DataTerraformRemoteStateManta", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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