import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class OssBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: OssBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateOss extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateOssConfig);
}
export interface OssBackendProps {
    readonly accessKey?: string;
    readonly secretKey?: string;
    readonly securityToken?: string;
    readonly ecsRoleName?: string;
    readonly region?: string;
    readonly endpoint?: string;
    readonly bucket: string;
    readonly prefix?: string;
    readonly key?: string;
    readonly tablestoreEndpoint?: string;
    readonly tablestoreTable?: string;
    readonly encrypt?: boolean;
    readonly acl?: string;
    readonly sharedCredentialsFile?: string;
    readonly profile?: string;
    readonly assumeRole?: OssAssumeRole;
}
export interface OssAssumeRole {
    readonly roleArn: string;
    readonly policy?: string;
    readonly sessionName?: string;
    readonly sessionExpiration?: number;
}
export interface DataTerraformRemoteStateOssConfig extends DataTerraformRemoteStateConfig, OssBackendProps {
}
