import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class PgBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: PgBackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStatePg extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStatePgConfig);
}
export interface PgBackendProps {
    readonly connStr: string;
    readonly schemaName?: string;
    readonly skipSchemaCreation?: boolean;
}
export interface DataTerraformRemoteStatePgConfig extends DataTerraformRemoteStateConfig, PgBackendProps {
}
