"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStatePg = exports.PgBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class PgBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "pg");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStatePg(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.PgBackend = PgBackend;
_a = JSII_RTTI_SYMBOL_1;
PgBackend[_a] = { fqn: "cdktf.PgBackend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStatePg extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "pg", config);
    }
}
exports.DataTerraformRemoteStatePg = DataTerraformRemoteStatePg;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStatePg[_b] = { fqn: "cdktf.DataTerraformRemoteStatePg", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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