import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class S3Backend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: S3BackendProps);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateS3 extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateS3Config);
}
export interface S3BackendProps {
    readonly bucket: string;
    readonly key: string;
    readonly region?: string;
    readonly endpoint?: string;
    readonly encrypt?: boolean;
    readonly acl?: string;
    readonly accessKey?: string;
    readonly secretKey?: string;
    readonly kmsKeyId?: string;
    readonly dynamodbTable?: string;
    readonly profile?: string;
    readonly sharedCredentialsFile?: string;
    readonly token?: string;
    readonly roleArn?: string;
    readonly assumeRolePolicy?: string;
    readonly externalId?: string;
    readonly sessionName?: string;
    readonly workspaceKeyPrefix?: string;
    readonly dynamodbEndpoint?: string;
    readonly iamEndpoint?: string;
    readonly stsEndpoint?: string;
    readonly forcePathStyle?: boolean;
    readonly skipCredentialsValidation?: boolean;
    readonly skipMetadataApiCheck?: boolean;
    readonly sseCustomerKey?: string;
    readonly maxRetries?: number;
}
export interface DataTerraformRemoteStateS3Config extends DataTerraformRemoteStateConfig, S3BackendProps {
}
