"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateS3 = exports.S3Backend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
class S3Backend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "s3");
        this.props = props;
    }
    synthesizeAttributes() {
        return util_1.keysToSnakeCase({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateS3(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.S3Backend = S3Backend;
_a = JSII_RTTI_SYMBOL_1;
S3Backend[_a] = { fqn: "cdktf.S3Backend", version: "0.11.0-pre.4" };
class DataTerraformRemoteStateS3 extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "s3", config);
    }
}
exports.DataTerraformRemoteStateS3 = DataTerraformRemoteStateS3;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateS3[_b] = { fqn: "cdktf.DataTerraformRemoteStateS3", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMtYmFja2VuZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInMzLWJhY2tlbmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSw0REFBd0Q7QUFDeEQsa0NBQTBDO0FBQzFDLHNFQUdtQztBQUVuQyxNQUFhLFNBQVUsU0FBUSxvQ0FBZ0I7SUFDN0MsWUFBWSxLQUFnQixFQUFtQixLQUFxQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQURlLFVBQUssR0FBTCxLQUFLLENBQWdCO0lBRXBFLENBQUM7SUFFUyxvQkFBb0I7UUFDNUIsT0FBTyxzQkFBZSxDQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRU0sd0JBQXdCLENBQzdCLEtBQWdCLEVBQ2hCLElBQVksRUFDWixVQUFrQjtRQUVsQixPQUFPLElBQUksMEJBQTBCLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUNqRCxHQUFHLElBQUksQ0FBQyxLQUFLO1lBQ2IsU0FBUyxFQUFFLHdCQUF3QjtTQUNwQyxDQUFDLENBQUM7SUFDTCxDQUFDOztBQWxCSCw4QkFtQkM7OztBQUVELE1BQWEsMEJBQTJCLFNBQVEsNkNBQW9CO0lBQ2xFLFlBQ0UsS0FBZ0IsRUFDaEIsRUFBVSxFQUNWLE1BQXdDO1FBRXhDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQztJQUNqQyxDQUFDOztBQVBILGdFQVFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IFRlcnJhZm9ybUJhY2tlbmQgfSBmcm9tIFwiLi4vdGVycmFmb3JtLWJhY2tlbmRcIjtcbmltcG9ydCB7IGtleXNUb1NuYWtlQ2FzZSB9IGZyb20gXCIuLi91dGlsXCI7XG5pbXBvcnQge1xuICBUZXJyYWZvcm1SZW1vdGVTdGF0ZSxcbiAgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlQ29uZmlnLFxufSBmcm9tIFwiLi4vdGVycmFmb3JtLXJlbW90ZS1zdGF0ZVwiO1xuXG5leHBvcnQgY2xhc3MgUzNCYWNrZW5kIGV4dGVuZHMgVGVycmFmb3JtQmFja2VuZCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFMzQmFja2VuZFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIFwiYmFja2VuZFwiLCBcInMzXCIpO1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ga2V5c1RvU25ha2VDYXNlKHsgLi4udGhpcy5wcm9wcyB9KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRSZW1vdGVTdGF0ZURhdGFTb3VyY2UoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBuYW1lOiBzdHJpbmcsXG4gICAgX2Zyb21TdGFjazogc3RyaW5nXG4gICk6IFRlcnJhZm9ybVJlbW90ZVN0YXRlIHtcbiAgICByZXR1cm4gbmV3IERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZVMzKHNjb3BlLCBuYW1lLCB7XG4gICAgICAuLi50aGlzLnByb3BzLFxuICAgICAgd29ya3NwYWNlOiBcIiR7dGVycmFmb3JtLndvcmtzcGFjZX1cIixcbiAgICB9KTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlUzMgZXh0ZW5kcyBUZXJyYWZvcm1SZW1vdGVTdGF0ZSB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBjb25maWc6IERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZVMzQ29uZmlnXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgXCJzM1wiLCBjb25maWcpO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUzNCYWNrZW5kUHJvcHMge1xuICByZWFkb25seSBidWNrZXQ6IHN0cmluZztcbiAgcmVhZG9ubHkga2V5OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlZ2lvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgZW5kcG9pbnQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGVuY3J5cHQ/OiBib29sZWFuO1xuICByZWFkb25seSBhY2w/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGFjY2Vzc0tleT86IHN0cmluZztcbiAgcmVhZG9ubHkgc2VjcmV0S2V5Pzogc3RyaW5nO1xuICByZWFkb25seSBrbXNLZXlJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgZHluYW1vZGJUYWJsZT86IHN0cmluZztcbiAgcmVhZG9ubHkgcHJvZmlsZT86IHN0cmluZztcbiAgcmVhZG9ubHkgc2hhcmVkQ3JlZGVudGlhbHNGaWxlPzogc3RyaW5nO1xuICByZWFkb25seSB0b2tlbj86IHN0cmluZztcbiAgcmVhZG9ubHkgcm9sZUFybj86IHN0cmluZztcbiAgcmVhZG9ubHkgYXNzdW1lUm9sZVBvbGljeT86IHN0cmluZztcbiAgcmVhZG9ubHkgZXh0ZXJuYWxJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgc2Vzc2lvbk5hbWU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHdvcmtzcGFjZUtleVByZWZpeD86IHN0cmluZztcbiAgcmVhZG9ubHkgZHluYW1vZGJFbmRwb2ludD86IHN0cmluZztcbiAgcmVhZG9ubHkgaWFtRW5kcG9pbnQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHN0c0VuZHBvaW50Pzogc3RyaW5nO1xuICByZWFkb25seSBmb3JjZVBhdGhTdHlsZT86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHNraXBDcmVkZW50aWFsc1ZhbGlkYXRpb24/OiBib29sZWFuO1xuICByZWFkb25seSBza2lwTWV0YWRhdGFBcGlDaGVjaz86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHNzZUN1c3RvbWVyS2V5Pzogc3RyaW5nO1xuICByZWFkb25seSBtYXhSZXRyaWVzPzogbnVtYmVyO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZVMzQ29uZmlnXG4gIGV4dGVuZHMgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlQ29uZmlnLFxuICAgIFMzQmFja2VuZFByb3BzIHt9XG4iXX0=