import { IResolvable } from "./tokens";
import { IInterpolatingParent, ITerraformAddressable } from "./terraform-addressable";
declare abstract class ComplexComputedAttribute implements IInterpolatingParent {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    getStringAttribute(terraformAttribute: string): string;
    getNumberAttribute(terraformAttribute: string): number;
    getListAttribute(terraformAttribute: string): string[];
    getBooleanAttribute(terraformAttribute: string): IResolvable;
    getNumberListAttribute(terraformAttribute: string): number[];
    getStringMapAttribute(terraformAttribute: string): {
        [key: string]: string;
    };
    getNumberMapAttribute(terraformAttribute: string): {
        [key: string]: number;
    };
    getBooleanMapAttribute(terraformAttribute: string): {
        [key: string]: boolean;
    };
    getAnyMapAttribute(terraformAttribute: string): {
        [key: string]: any;
    };
    abstract interpolationForAttribute(terraformAttribute: string): any;
}
export declare class StringMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): string;
}
export declare class NumberMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): number;
}
export declare class BooleanMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): IResolvable;
}
export declare class AnyMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): any;
}
/**
 * @deprecated Going to be replaced by Array of ComplexListItem
 * and will be removed in the future
 */
export declare class ComplexComputedList extends ComplexComputedAttribute {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected complexComputedListIndex: string;
    protected wrapsSet?: boolean | undefined;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, complexComputedListIndex: string, wrapsSet?: boolean | undefined);
    interpolationForAttribute(property: string): IResolvable;
}
export declare abstract class ComplexList implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get fqn(): string;
}
export declare abstract class ComplexMap implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    get fqn(): string;
}
export declare class ComplexObject extends ComplexComputedAttribute {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected complexObjectIsFromSet: boolean;
    protected complexObjectIndex?: string | number | undefined;
    /**
     * @param terraformResource
     * @param terraformAttribute
     * @param complexObjectIndex the index of the complex object in a list
     * @param complexObjectIsFromSet set to true if this item is from inside a set and needs tolist() for accessing it
     *                               set to "0" for single list items
     */
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, complexObjectIsFromSet: boolean, complexObjectIndex?: string | number | undefined);
    interpolationForAttribute(property: string): IResolvable;
    protected interpolationAsList(): IResolvable;
}
export {};
