"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComplexObject = exports.ComplexMap = exports.ComplexList = exports.ComplexComputedList = exports.AnyMap = exports.BooleanMap = exports.NumberMap = exports.StringMap = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const _1 = require(".");
class ComplexComputedAttribute {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
}
class StringMap {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
}
exports.StringMap = StringMap;
_a = JSII_RTTI_SYMBOL_1;
StringMap[_a] = { fqn: "cdktf.StringMap", version: "0.11.0-pre.4" };
class NumberMap {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asNumber(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
}
exports.NumberMap = NumberMap;
_b = JSII_RTTI_SYMBOL_1;
NumberMap[_b] = { fqn: "cdktf.NumberMap", version: "0.11.0-pre.4" };
class BooleanMap {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`);
    }
}
exports.BooleanMap = BooleanMap;
_c = JSII_RTTI_SYMBOL_1;
BooleanMap[_c] = { fqn: "cdktf.BooleanMap", version: "0.11.0-pre.4" };
class AnyMap {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asAny(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
}
exports.AnyMap = AnyMap;
_d = JSII_RTTI_SYMBOL_1;
AnyMap[_d] = { fqn: "cdktf.AnyMap", version: "0.11.0-pre.4" };
/**
 * @deprecated Going to be replaced by Array of ComplexListItem
 * and will be removed in the future
 */
class ComplexComputedList extends ComplexComputedAttribute {
    constructor(terraformResource, terraformAttribute, complexComputedListIndex, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexComputedListIndex = complexComputedListIndex;
        this.wrapsSet = wrapsSet;
        throw new Error("Version mismatch detected: The provider bindings seem to have been built for an older version of CDKTF. Upgrade your pre-built provider or re-run cdktf get with a more recent version (>= 0.10) of the cdktf-cli.");
    }
    interpolationForAttribute(property) {
        if (this.wrapsSet) {
            return _1.propertyAccess(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexComputedListIndex, property]);
        }
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${this.complexComputedListIndex}].${property}`);
    }
}
exports.ComplexComputedList = ComplexComputedList;
_e = JSII_RTTI_SYMBOL_1;
ComplexComputedList[_e] = { fqn: "cdktf.ComplexComputedList", version: "0.11.0-pre.4" };
class ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get fqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
exports.ComplexList = ComplexList;
_f = JSII_RTTI_SYMBOL_1;
ComplexList[_f] = { fqn: "cdktf.ComplexList", version: "0.11.0-pre.4" };
class ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get fqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
exports.ComplexMap = ComplexMap;
_g = JSII_RTTI_SYMBOL_1;
ComplexMap[_g] = { fqn: "cdktf.ComplexMap", version: "0.11.0-pre.4" };
class ComplexObject extends ComplexComputedAttribute {
    /**
     * @param terraformResource
     * @param terraformAttribute
     * @param complexObjectIndex the index of the complex object in a list
     * @param complexObjectIsFromSet set to true if this item is from inside a set and needs tolist() for accessing it
     *                               set to "0" for single list items
     */
    constructor(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexObjectIsFromSet = complexObjectIsFromSet;
        this.complexObjectIndex = complexObjectIndex;
    }
    interpolationForAttribute(property) {
        if (this.complexObjectIsFromSet) {
            return _1.propertyAccess(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexObjectIndex, property]);
        }
        return this.terraformResource.interpolationForAttribute(this.complexObjectIndex !== undefined
            ? `${this.terraformAttribute}[${this.complexObjectIndex}].${property}`
            : `${this.terraformAttribute}.${property}`);
    }
    interpolationAsList() {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}.*`);
    }
}
exports.ComplexObject = ComplexObject;
_h = JSII_RTTI_SYMBOL_1;
ComplexObject[_h] = { fqn: "cdktf.ComplexObject", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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