"use strict";
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdktf.json` file. In the next major release of the CDK for Terraform, these feature flags
// will be removed and will become the default behavior.
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.FUTURE_FLAGS = exports.ALLOW_SEP_CHARS_IN_LOGICAL_IDS = exports.EXCLUDE_STACK_ID_FROM_LOGICAL_IDS = void 0;
/**
 * When set, the stack id is excluded from generated logical ids for constructs within the stack.
 */
exports.EXCLUDE_STACK_ID_FROM_LOGICAL_IDS = "excludeStackIdFromLogicalIds";
/**
 * When set, '_' and '-' are allowed in logical ids.
 */
exports.ALLOW_SEP_CHARS_IN_LOGICAL_IDS = "allowSepCharsInLogicalIds";
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdktf init` will include these flags in their
 * generated `cdktf.json` file.
 *
 * When we release the next major version of the CDK for Terraform, we will flip the logic of
 * these features and clean up the `cdktf.json` generated by `cdktf init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.EXCLUDE_STACK_ID_FROM_LOGICAL_IDS]: "true",
    [exports.ALLOW_SEP_CHARS_IN_LOGICAL_IDS]: "true",
};
//# sourceMappingURL=data:application/json;base64,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