"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs");
class Manifest {
    constructor(version, outdir) {
        this.version = version;
        this.outdir = outdir;
        this.stacks = {};
        const stacksPath = path.join(this.outdir, Manifest.stacksFolder);
        if (!fs.existsSync(stacksPath))
            fs.mkdirSync(stacksPath);
    }
    forStack(stack) {
        const node = stack.node;
        const name = node.id;
        if (this.stacks[name]) {
            return this.stacks[name];
        }
        const manifest = {
            name,
            constructPath: node.path,
            workingDirectory: path.join(Manifest.stacksFolder, node.id),
            synthesizedStackPath: path.join(Manifest.stacksFolder, node.id, Manifest.stackFileName),
            annotations: [],
            dependencies: stack.dependencies.map((item) => item.node.path),
        };
        this.stacks[name] = manifest;
        return manifest;
    }
    buildManifest() {
        return {
            version: this.version,
            stacks: this.stacks,
        };
    }
    writeToFile() {
        fs.writeFileSync(path.join(this.outdir, Manifest.fileName), JSON.stringify(this.buildManifest(), undefined, 2));
    }
}
exports.Manifest = Manifest;
_a = JSII_RTTI_SYMBOL_1;
Manifest[_a] = { fqn: "cdktf.Manifest", version: "0.11.0-pre.4" };
Manifest.fileName = "manifest.json";
Manifest.stacksFolder = "stacks";
Manifest.stackFileName = "cdk.tf.json";
//# sourceMappingURL=data:application/json;base64,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