"use strict";
// ----------------------------------------------------------------------
// PROPERTY MAPPERS
//
// These are used while converting generated classes/property bags to Terraform JSON objects
//
// We use identity mappers for the primitive types. These don't do anything but are there to make the code
// generation work out nicely (so the code generator doesn't need to emit different code for primitive
Object.defineProperty(exports, "__esModule", { value: true });
exports.isComplexElement = exports.canInspect = exports.hashMapper = exports.listMapper = exports.numberToTerraform = exports.anyToTerraform = exports.booleanToTerraform = exports.stringToTerraform = void 0;
const encoding_1 = require("./tokens/private/encoding");
Object.defineProperty(exports, "isComplexElement", { enumerable: true, get: function () { return encoding_1.isComplexElement; } });
const tokens_1 = require("./tokens");
function identity(x) {
    return x;
}
exports.stringToTerraform = identity;
exports.booleanToTerraform = identity;
exports.anyToTerraform = identity;
exports.numberToTerraform = identity;
function listMapper(elementMapper) {
    return (x) => {
        if (!canInspect(x)) {
            return x;
        }
        if (!Array.isArray(x)) {
            return x;
        }
        return x.map(elementMapper);
    };
}
exports.listMapper = listMapper;
function hashMapper(elementMapper) {
    return (x) => {
        if (!canInspect(x)) {
            return x;
        }
        // Check if it's a token object
        if (encoding_1.containsComplexElement(x)) {
            return x;
        }
        if (tokens_1.Tokenization.isResolvable(x)) {
            return x;
        }
        // We can't treat strings as hashes (likely a token or a misconfiguration)
        if (typeof x === "string") {
            return x;
        }
        if (encoding_1.containsMapToken(x)) {
            return x;
        }
        const ret = {};
        Object.keys(x).forEach((key) => {
            ret[key] = elementMapper(x[key]);
        });
        return ret;
    };
}
exports.hashMapper = hashMapper;
/**
 * Return whether this object can be validated at all
 *
 * True unless it's undefined
 */
function canInspect(x) {
    // Note: using weak equality on purpose, we also want to catch undefined
    return x != null;
}
exports.canInspect = canInspect;
//# sourceMappingURL=data:application/json;base64,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