"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const BACKEND_SYMBOL = Symbol.for("cdktf/TerraformBackend");
class TerraformBackend extends terraform_element_1.TerraformElement {
    constructor(scope, id, name) {
        super(scope, id);
        this.name = name;
        Object.defineProperty(this, BACKEND_SYMBOL, { value: true });
    }
    static isBackend(x) {
        return x !== null && typeof x === "object" && BACKEND_SYMBOL in x;
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            terraform: {
                backend: {
                    [this.name]: util_1.deepMerge(this.synthesizeAttributes(), this.rawOverrides),
                },
            },
        };
    }
    toMetadata() {
        return {
            backend: this.name,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { backend: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.TerraformBackend = TerraformBackend;
_a = JSII_RTTI_SYMBOL_1;
TerraformBackend[_a] = { fqn: "cdktf.TerraformBackend", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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