"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformDataSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
class TerraformDataSource extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => tfExpression_1.insideTfExpression(dependency.fqn));
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
        this.fqn = tokens_1.Token.asString(tfExpression_1.ref(`data.${this.terraformResourceType}.${this.friendlyUniqueId}`, this.cdktfStack));
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
    get terraformMetaArguments() {
        var _b;
        return {
            dependsOn: this.dependsOn,
            count: this.count,
            provider: (_b = this.provider) === null || _b === void 0 ? void 0 : _b.fqn,
            lifecycle: this.lifecycle,
        };
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        const attributes = util_1.deepMerge(this.synthesizeAttributes(), util_1.keysToSnakeCase(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            data: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    interpolationForAttribute(terraformAttribute) {
        return tfExpression_1.ref(`data.${this.terraformResourceType}.${this.friendlyUniqueId}.${terraformAttribute}`, this.cdktfStack);
    }
}
exports.TerraformDataSource = TerraformDataSource;
_a = JSII_RTTI_SYMBOL_1;
TerraformDataSource[_a] = { fqn: "cdktf.TerraformDataSource", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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