import { Construct } from "constructs";
import { TerraformStack } from "./terraform-stack";
export interface TerraformElementMetadata {
    readonly path: string;
    readonly uniqueId: string;
    readonly stackTrace: string[];
}
export declare class TerraformElement extends Construct {
    readonly cdktfStack: TerraformStack;
    protected readonly rawOverrides: any;
    /**
     * An explicit logical ID provided by `overrideLogicalId`.
     */
    private _logicalIdOverride?;
    constructor(scope: Construct, id: string);
    toTerraform(): any;
    toMetadata(): any;
    get friendlyUniqueId(): string;
    /**
     * Overrides the auto-generated logical ID with a specific ID.
     * @param newLogicalId The new logical ID to use for this stack element.
     */
    overrideLogicalId(newLogicalId: string): void;
    /**
     * Resets a previously passed logical Id to use the auto-generated logical id again
     */
    resetOverrideLogicalId(): void;
    addOverride(path: string, value: any): void;
    protected get constructNodeMetadata(): {
        [key: string]: any;
    };
}
