"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformElement = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const _1 = require(".");
const terraform_stack_1 = require("./terraform-stack");
class TerraformElement extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.rawOverrides = {};
        if (_1.Token.isUnresolved(id)) {
            throw new Error("You cannot use a Token (e.g. a reference to an attribute) as the id of a construct");
        }
        this.node.addMetadata("stacktrace", "trace");
        this.cdktfStack = terraform_stack_1.TerraformStack.of(this);
    }
    toTerraform() {
        return {};
    }
    toMetadata() {
        return {};
    }
    get friendlyUniqueId() {
        if (this._logicalIdOverride) {
            return this._logicalIdOverride;
        }
        else {
            return this.cdktfStack.getLogicalId(this);
        }
    }
    /**
     * Overrides the auto-generated logical ID with a specific ID.
     * @param newLogicalId The new logical ID to use for this stack element.
     */
    overrideLogicalId(newLogicalId) {
        this._logicalIdOverride = newLogicalId;
    }
    /**
     * Resets a previously passed logical Id to use the auto-generated logical id again
     */
    resetOverrideLogicalId() {
        this._logicalIdOverride = undefined;
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    get constructNodeMetadata() {
        var _b;
        return {
            metadata: {
                path: this.node.path,
                uniqueId: this.friendlyUniqueId,
                stackTrace: (_b = this.node.metadata.find((e) => e.type === "stacktrace")) === null || _b === void 0 ? void 0 : _b.trace,
            },
        };
    }
}
exports.TerraformElement = TerraformElement;
_a = JSII_RTTI_SYMBOL_1;
TerraformElement[_a] = { fqn: "cdktf.TerraformElement", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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