import { IResolvable } from "./tokens/resolvable";
export declare class Fn {
    /**
     * {@link https://www.terraform.io/docs/language/functions/alltrue.html alltrue} returns true if all elements in a given collection are true or "true".
     * @param {Array} values
     */
    static alltrue(values: any[]): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/anytrue.html anytrue} returns true if any element in a given collection is true or "true"
     * @param {Array} value
     */
    static anytrue(value: any[]): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/chunklist.html chunklist} splits a single list into fixed-size chunks, returning a list of lists.
     * @param {Array} value
     * @param {number} chunkSize
     */
    static chunklist(value: any[], chunkSize: number): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/coalesce.html coalesce} takes any number of arguments and returns the first one that isn't null or an empty string.
     * @param {Array} value - Arguments are passed in an array
     */
    static coalesce(value: any[]): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/coalescelist.html coalescelist} takes any number of list arguments and returns the first one that isn't empty.
     * @param Array} value - Arguments are passed in an array
     */
    static coalescelist(value: any[][]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/compact.html compact} takes a list of strings and returns a new list with any empty string elements removed.
     * @param {Array} value
     */
    static compact(value: string[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/concat.html concat} takes two or more lists and combines them into a single list.
     * @param {Array} value
     */
    static concat(value: any[][]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/contains.html contains} determines whether a given list or set contains a given single value as one of its elements.
     * @param {Array} list
     * @param {any} value
     */
    static contains(list: any[] | IResolvable, value: any): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/distinct.html distinct} takes a list and returns a new list with any duplicate elements removed.
     * @param {Array} list
     */
    static distinct(list: any[] | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/element.html element} retrieves a single element from a list.
     * @param {Array} list
     * @param {number} index
     */
    static element(list: any[] | IResolvable, index: number): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/flatten.html flatten} takes a list and replaces any elements that are lists with a flattened sequence of the list contents.
     * @param {Array} list
     */
    static flatten(list: any[] | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/index.html index} finds the element index for a given value in a list.
     * @param {Array} list
     * @param {any} value
     */
    static index(list: any[] | IResolvable, value: any): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/keys.html keys} takes a map and returns a list containing the keys from that map.
     * @param {Object} map
     */
    static keys(map: Record<string, any> | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/length.html length} determines the length of a given list, map, or string.
     * @param {Object|Array|string} value
     */
    static lengthOf(value: any): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/lookup.html lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     * @param {Object} value
     * @param {any} key
     * @param {any} defaultValue
     */
    static lookup(value: any, key: any, defaultValue: any): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/matchkeys.html matchkeys} constructs a new list by taking a subset of elements from one list whose indexes match the corresponding indexes of values in another list.
     * @param {Array} valuesList
     * @param {Array} keysList
     * @param {Array} searchSet
     */
    static matchkeys(valuesList: any[] | string | IResolvable, keysList: any[] | string | IResolvable, searchSet: any[] | string | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/merge.html merge} takes an arbitrary number of maps or objects, and returns a single map or object that contains a merged set of elements from all arguments.
     * @param {Array)} values - Arguments are passed in an array
     */
    static merge(values: any[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/one.html one} takes a list, set, or tuple value with either zero or one elements.
     * @param {Array} list
     */
    static one(list: any[] | string | IResolvable): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/range.html range} generates a list of numbers using a start value, a limit value, and a step value.
     * @param {number} start
     * @param {number} limit
     * @param {number=1} step
     */
    static range(start: number, limit: number, step?: number): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/reverse.html reverse} takes a sequence and produces a new sequence of the same length with all of the same elements as the given sequence but in reverse order.
     * @param {Array} values
     */
    static reverse(values: any[] | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/setintersection.html setintersection} function takes multiple sets and produces a single set containing only the elements that all of the given sets have in common
     * @param {Array} values
     */
    static setintersection(values: any[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/setproduct.html setproduct} function finds all of the possible combinations of elements from all of the given sets by computing the Cartesian product.
     * @param {Array} values
     */
    static setproduct(values: any[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/slice.html setsubtract} function returns a new set containing the elements from the first set that are not present in the second set.
     * @param {Array} minuend
     * @param {Array} subtrahend
     */
    static setsubtract(minuend: any[] | string | IResolvable, subtrahend: any[] | string | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/setunion.html setunion} function takes multiple sets and produces a single set containing the elements from all of the given sets.
     * @param {Array} values - Arguments are passed in an array
     */
    static setunion(values: any[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/slice.html slice} extracts some consecutive elements from within a list.
     * @param {Array} list
     * @param {number} startindex
     * @param {number} endindex
     */
    static slice(list: any[] | string | IResolvable, startindex: number, endindex: number): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/sort.html sort} takes a list of strings and returns a new list with those strings sorted lexicographically.
     * @param {Array} list
     */
    static sort(list: any[] | string | IResolvable): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/sum.html sum} takes a list or set of numbers and returns the sum of those numbers.
     * @param {Array} list
     */
    static sum(list: any[] | string | IResolvable): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/transpose.html transpose} takes a map of lists of strings and swaps the keys and values to produce a new map of lists of strings.
     * @param {Object} value
     */
    static transpose(value: any): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/values.html values} takes a map and returns a list containing the values of the elements in that map.
     * @param {Object} value
     */
    static values(value: any): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/zipmap.html zipmap} constructs a map from a list of keys and a corresponding list of values.
     * @param {Array} keyslist
     * @param {Array} valueslist
     */
    static zipmap(keyslist: any[] | IResolvable, valueslist: any[] | IResolvable): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/base64sha256.html base64sha256} computes the SHA256 hash of a given string and encodes it with Base64.
     * @param {string} value
     */
    static base64sha256(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/base64sha512.html base64sha512} computes the SHA512 hash of a given string and encodes it with Base64.
     * @param {string} value
     */
    static base64sha512(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/bcrypt.html bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in the Modular Crypt Format usually expected in the shadow password file on many Unix systems.
     * @param {string} value
     * @param {number=10} cost
     */
    static bcrypt(value: string, cost?: number): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/filebase64sha256.html filebase64sha256} is a variant of base64sha256 that hashes the contents of a given file rather than a literal string.
     * @param {string} value
     */
    static filebase64sha256(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/filebase64sha512.html filebase64sha512} is a variant of base64sha512 that hashes the contents of a given file rather than a literal string.
     * @param {string} value
     */
    static filebase64sha512(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/filemd5.html filemd5} is a variant of md5 that hashes the contents of a given file rather than a literal string.
     * @param {string} value
     */
    static filemd5(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/filesha1.html filesha1} is a variant of sha1 that hashes the contents of a given file rather than a literal string.
     * @param {string} value
     */
    static filesha1(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/filesha256.html filesha256} is a variant of sha256 that hashes the contents of a given file rather than a literal string.
     * @param {string} value
     */
    static filesha256(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/filesha512.html filesha512} is a variant of sha512 that hashes the contents of a given file rather than a literal string.
     * @param {string} value
     */
    static filesha512(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/md5.html md5} computes the MD5 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} value
     */
    static md5(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/rsadecrypt.html rsadecrypt} decrypts an RSA-encrypted ciphertext, returning the corresponding cleartext.
     * @param {string} ciphertext
     * @param {string} privatekey
     */
    static rsadecrypt(ciphertext: string, privatekey: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/sha1.html sha1} computes the SHA1 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} value
     */
    static sha1(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/sha256.html sha256} computes the SHA256 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} value
     */
    static sha256(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/sha512.html sha512} computes the SHA512 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} value
     */
    static sha512(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/uuid.html uuid} generates a unique identifier string.
     */
    static uuid(): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/uuidv5.html uuidv5} generates a unique identifier string.
     * @param {string} namespace
     * @param {string} name
     */
    static uuidv5(namespace: string, name: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/formatdate.html formatdate} converts a timestamp into a different time format.
     * @param {string} spec
     * @param {string} timestamp
     */
    static formatdate(spec: string, timestamp: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/timeadd.html timeadd} adds a duration to a timestamp, returning a new timestamp.
     * @param {string} timestamp
     * @param {string} duration
     */
    static timeadd(timestamp: string, duration: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/timestamp.html timestamp} returns a UTC timestamp string in RFC 3339 format.
     */
    static timestamp(): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/base64decode.html base64decode} takes a string containing a Base64 character sequence and returns the original string.
     * @param {string} value
     */
    static base64decode(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/base64encode.html base64encode} takes a string containing a Base64 character sequence and returns the original string.
     * @param {string} value
     */
    static base64encode(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/base64gzip.html base64gzip} compresses a string with gzip and then encodes the result in Base64 encoding.
     * @param {string} value
     */
    static base64gzip(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/csvdecode.html csvdecode} decodes a string containing CSV-formatted data and produces a list of maps representing that data.
     * @param {string} value
     */
    static csvdecode(value: string): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/jsondecode.html jsondecode} interprets a given string as JSON, returning a representation of the result of decoding that string.
     * @param {string} value
     */
    static jsondecode(value: string): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/jsonencode.html jsonencode} encodes a given value to a string using JSON syntax.
     * @param {any} value
     */
    static jsonencode(value: any): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/textdecodebase64.html textdecodebase64} function decodes a string that was previously Base64-encoded, and then interprets the result as characters in a specified character encoding.
     * @param {string} value
     * @param {string} encodingName
     */
    static textdecodebase64(value: string, encodingName: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/textencodebase64.html textencodebase64}  encodes the unicode characters in a given string using a specified character encoding, returning the result base64 encoded because Terraform language strings are always sequences of unicode characters.
     * @param {string} value
     * @param {string} encodingName
     */
    static textencodebase64(value: string, encodingName: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/urlencode.html urlencode} applies URL encoding to a given string.
     * @param {string} value
     */
    static urlencode(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/yamldecode.html yamldecode} parses a string as a subset of YAML, and produces a representation of its value.
     * @param {string} value
     */
    static yamldecode(value: string): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/yamlencode.html yamlencode} encodes a given value to a string using JSON syntax.
     * @param {any} value
     */
    static yamlencode(value: any): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/abspath.html abspath} takes a string containing a filesystem path and converts it to an absolute path.
     * @param {string} value
     */
    static abspath(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/dirname.html dirname} takes a string containing a filesystem path and removes the last portion from it.
     * @param {string} value
     */
    static dirname(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/pathexpand.html pathexpand} takes a string containing a filesystem path and removes the last portion from it.
     * @param {string} value
     */
    static pathexpand(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/basename.html basename} takes a string containing a filesystem path and removes all except the last portion from it.
     * @param {string} value
     */
    static basename(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/file.html file} takes a string containing a filesystem path and removes all except the last portion from it.
     * @param {string} value
     */
    static file(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/fileexists.html fileexists} determines whether a file exists at a given path.
     * @param {string} value
     */
    static fileexists(value: string): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/fileset.html fileset} enumerates a set of regular file names given a path and pattern.
     * @param {string} path
     * @param {string} pattern
     */
    static fileset(path: string, pattern: string): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/filebase64.html filebase64} reads the contents of a file at the given path and returns them as a base64-encoded string.
     * @param {string} value
     */
    static filebase64(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/templatefile.html templatefile} reads the file at the given path and renders its content as a template using a supplied set of template variables.
     * @param {string} path
     * @param {Object} vars
     */
    static templatefile(path: string, vars: any): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/cidrhost.html cidrhost} calculates a full host IP address for a given host number within a given IP network address prefix.
     * @param {string} prefix
     * @param {number} hostnum
     */
    static cidrhost(prefix: string, hostnum: number): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/cidrnetmask.html cidrnetmask} converts an IPv4 address prefix given in CIDR notation into a subnet mask address.
     * @param {string} prefix
     */
    static cidrnetmask(prefix: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/cidrsubnet.html cidrsubnet} calculates a subnet address within given IP network address prefix.
     * @param {string} prefix
     * @param {number} newbits
     * @param {number} netnum
     */
    static cidrsubnet(prefix: string, newbits: number, netnum: number): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/cidrsubnets.html cidrsubnets} calculates a sequence of consecutive IP address ranges within a particular CIDR prefix.
     * @param {string} prefix
     * @param {...number} newbits
     */
    static cidrsubnets(prefix: string, newbits: number[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/abs.html abs} returns the absolute value of the given number
     * @param {number} value
     */
    static abs(value: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/ceil.html ceil} returns the closest whole number that is greater than or equal to the given value, which may be a fraction.
     * @param {number} value
     */
    static ceil(value: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/floor.html floor} returns the closest whole number that is less than or equal to the given value, which may be a fraction
     * @param {number} value
     */
    static floor(value: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/log.html log} returns the logarithm of a given number in a given base.
     * @param {number} value
     * @param {number} base
     */
    static log(value: number, base: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/max.html max} takes one or more numbers and returns the greatest number from the set.
     * @param {Array<number>} values
     */
    static max(values: number[]): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/min.html min} takes one or more numbers and returns the smallest number from the set.
     * @param {Array<number>} values
     */
    static min(values: number[]): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/parseint.html parseInt} parses the given string as a representation of an integer in the specified base and returns the resulting number. The base must be between 2 and 62 inclusive.
     * @param {string} value
     * @param {number} base
     */
    static parseInt(value: string, base: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/pow.html pow} calculates an exponent, by raising its first argument to the power of the second argument.
     * @param {number} value
     * @param {number} power
     */
    static pow(value: number, power: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/signum.html signum} determines the sign of a number, returning a number between -1 and 1 to represent the sign.
     * @param {number} value
     */
    static signum(value: number): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/chomp.html chomp} removes newline characters at the end of a string.
     * @param {string} value
     */
    static chomp(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/format.html format} produces a string by formatting a number of other values according to a specification string
     * @param {string} spec
     * @param {Array} values
     */
    static format(spec: string, values: any[]): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/formatlist.html formatlist} produces a list of strings by formatting a number of other values according to a specification string.
     * @param {string} spec
     * @param {Array<string>} values
     */
    static formatlist(spec: string, values: any[]): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/indent.html indent} adds a given number of spaces to the beginnings of all but the first line in a given multi-line string.
     * @param {number} indentation
     * @param {string} value
     */
    static indent(indentation: number, value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/join.html join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     * @param {string} separator
     * @param {Array} value
     */
    static join(separator: string, value: string[]): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/lower.html lower} converts all cased letters in the given string to lowercase.
     * @param {string} value
     */
    static lower(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/regexall.html regexall} applies a regular expression to a string and returns a list of all matches.
     * @param {string} pattern
     * @param {string} value
     */
    static regexall(pattern: string, value: string): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/regex.html regex} applies a regular expression to a string and returns the matching substrings in pattern.
     * @param {string} pattern
     * @param {string} value
     */
    static regex(pattern: string, value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/replace.html replace} searches a given string for another given substring, and replaces each occurrence with a given replacement string.
     * @param {string} value
     * @param {string} substring
     * @param {string} replacement
     */
    static replace(value: string, substring: string, replacement: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/split.html split} produces a list by dividing a given string at all occurrences of a given separator.
     * @param {string} seperator
     * @param {string} value
     */
    static split(seperator: string, value: string): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/strrev.html strrev} reverses the characters in a string.
     * @param {string} value
     */
    static strrev(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/substr.html substr} extracts a substring from a given string by offset and length.
     * @param {string} value
     * @param {number} offset
     * @param {number} length
     */
    static substr(value: string, offset: number, length: number): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/title.html title} converts the first letter of each word in the given string to uppercase.
     * @param {string} value
     */
    static title(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/trim.html trim} removes the specified characters from the start and end of the given string.
     * @param {string} value
     * @param {string} replacement
     */
    static trim(value: string, replacement: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/trimprefix.html trimprefix} removes the specified prefix from the start of the given string.
     * @param {string} value
     * @param {string} prefix
     */
    static trimprefix(value: string, prefix: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/trimsuffix.html trimsuffix} removes the specified suffix from the end of the given string.
     * @param {string} value
     * @param {string} suffix
     */
    static trimsuffix(value: string, suffix: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/trimspace.html trimspace} removes any space characters from the start and end of the given string.
     * @param {string} value
     */
    static trimspace(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/upper.html upper} converts all cased letters in the given string to uppercase.
     * @param {string} value
     */
    static upper(value: string): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/can.html can} evaluates the given expression and returns a boolean value indicating whether the expression produced a result without any errors.
     * @param {any} expression
     */
    static can(expression: any): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/nonsensitive.html nonsensitive} takes a sensitive value and returns a copy of that value with the sensitive marking removed, thereby exposing the sensitive value.
     * @param {any} expression
     */
    static nonsensitive(expression: any): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/sensitive.html sensitive} takes any value and returns a copy of it marked so that Terraform will treat it as sensitive, with the same meaning and behavior as for sensitive input variables.
     * @param {any} expression
     */
    static sensitive(expression: any): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/tobool.html tobool} converts its argument to a boolean value.
     * @param {any} expression
     */
    static tobool(expression: any): IResolvable;
    /**
     * {@link https://www.terraform.io/docs/language/functions/tolist.html tolist} converts its argument to a list value.
     * @param {any} expression
     */
    static tolist(expression: any): string[];
    /**
     * {@link https://www.terraform.io/docs/language/functions/tomap.html tomap} converts its argument to a map value.
     * @param {any} expression
     */
    static tomap(expression: any): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/tonumber.html tonumber} converts its argument to a number value.
     * @param {any} expression
     */
    static tonumber(expression: any): number;
    /**
     * {@link https://www.terraform.io/docs/language/functions/toset.html toset} converts its argument to a set value.
     * @param {any} expression
     */
    static toset(expression: any): any;
    /**
     * {@link https://www.terraform.io/docs/language/functions/tostring.html tostring} converts its argument to a string value.
     * @param {any} expression
     */
    static tostring(expression: any): string;
    /**
     * {@link https://www.terraform.io/docs/language/functions/try.html try} evaluates all of its argument expressions in turn and returns the result of the first one that does not produce any errors.
     * @param {Array} expression
     */
    static try(expression: any[]): any;
    /**
     * Use this function to wrap a string and escape it properly for the use in Terraform
     * This is only needed in certain scenarios (e.g., if you have unescaped double quotes in the string)
     * @param {String} str
     */
    static rawString(str: string): string;
}
