import { Construct } from "constructs";
import { TerraformModuleOptions, TerraformModule } from "./terraform-module";
import { IResolvable } from "./tokens";
export interface TerraformHclModuleOptions extends TerraformModuleOptions {
    readonly variables?: {
        [key: string]: any;
    };
}
export declare class TerraformHclModule extends TerraformModule {
    private _variables?;
    constructor(scope: Construct, id: string, options: TerraformHclModuleOptions);
    get variables(): {
        [key: string]: any;
    } | undefined;
    set(variable: string, value: any): void;
    get(output: string): any;
    getNumber(output: string): number;
    getBoolean(output: string): IResolvable;
    getList(output: string): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
