"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformHclModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_module_1 = require("./terraform-module");
const tokens_1 = require("./tokens");
class TerraformHclModule extends terraform_module_1.TerraformModule {
    constructor(scope, id, options) {
        super(scope, id, options);
        this._variables = options.variables;
    }
    get variables() {
        return this._variables;
    }
    set(variable, value) {
        if (!this._variables) {
            this._variables = {};
        }
        this._variables[variable] = value;
    }
    get(output) {
        return tokens_1.Token.asAny(this.interpolationForOutput(output));
    }
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForOutput(output));
    }
    getBoolean(output) {
        return this.interpolationForOutput(output);
    }
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForOutput(output));
    }
    synthesizeAttributes() {
        return { ...this.variables };
    }
}
exports.TerraformHclModule = TerraformHclModule;
_a = JSII_RTTI_SYMBOL_1;
TerraformHclModule[_a] = { fqn: "cdktf.TerraformHclModule", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLWhjbC1tb2R1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXJyYWZvcm0taGNsLW1vZHVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHlEQUE2RTtBQUM3RSxxQ0FBOEM7QUFNOUMsTUFBYSxrQkFBbUIsU0FBUSxrQ0FBZTtJQUdyRCxZQUNFLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixPQUFrQztRQUVsQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUUxQixJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUVNLEdBQUcsQ0FBQyxRQUFnQixFQUFFLEtBQVU7UUFDckMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDcEIsSUFBSSxDQUFDLFVBQVUsR0FBRyxFQUFFLENBQUM7U0FDdEI7UUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBRU0sR0FBRyxDQUFDLE1BQWM7UUFDdkIsT0FBTyxjQUFLLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFTSxTQUFTLENBQUMsTUFBYztRQUM3QixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDN0QsQ0FBQztJQUVNLFVBQVUsQ0FBQyxNQUFjO1FBQzlCLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFTSxPQUFPLENBQUMsTUFBYztRQUMzQixPQUFPLGNBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUVTLG9CQUFvQjtRQUM1QixPQUFPLEVBQUUsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7SUFDL0IsQ0FBQzs7QUExQ0gsZ0RBMkNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IFRlcnJhZm9ybU1vZHVsZU9wdGlvbnMsIFRlcnJhZm9ybU1vZHVsZSB9IGZyb20gXCIuL3RlcnJhZm9ybS1tb2R1bGVcIjtcbmltcG9ydCB7IFRva2VuLCBJUmVzb2x2YWJsZSB9IGZyb20gXCIuL3Rva2Vuc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIFRlcnJhZm9ybUhjbE1vZHVsZU9wdGlvbnMgZXh0ZW5kcyBUZXJyYWZvcm1Nb2R1bGVPcHRpb25zIHtcbiAgcmVhZG9ubHkgdmFyaWFibGVzPzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcbn1cblxuZXhwb3J0IGNsYXNzIFRlcnJhZm9ybUhjbE1vZHVsZSBleHRlbmRzIFRlcnJhZm9ybU1vZHVsZSB7XG4gIHByaXZhdGUgX3ZhcmlhYmxlcz86IHsgW2tleTogc3RyaW5nXTogYW55IH07XG5cbiAgY29uc3RydWN0b3IoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIG9wdGlvbnM6IFRlcnJhZm9ybUhjbE1vZHVsZU9wdGlvbnNcbiAgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBvcHRpb25zKTtcblxuICAgIHRoaXMuX3ZhcmlhYmxlcyA9IG9wdGlvbnMudmFyaWFibGVzO1xuICB9XG5cbiAgcHVibGljIGdldCB2YXJpYWJsZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZhcmlhYmxlcztcbiAgfVxuXG4gIHB1YmxpYyBzZXQodmFyaWFibGU6IHN0cmluZywgdmFsdWU6IGFueSkge1xuICAgIGlmICghdGhpcy5fdmFyaWFibGVzKSB7XG4gICAgICB0aGlzLl92YXJpYWJsZXMgPSB7fTtcbiAgICB9XG4gICAgdGhpcy5fdmFyaWFibGVzW3ZhcmlhYmxlXSA9IHZhbHVlO1xuICB9XG5cbiAgcHVibGljIGdldChvdXRwdXQ6IHN0cmluZyk6IGFueSB7XG4gICAgcmV0dXJuIFRva2VuLmFzQW55KHRoaXMuaW50ZXJwb2xhdGlvbkZvck91dHB1dChvdXRwdXQpKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXROdW1iZXIob3V0cHV0OiBzdHJpbmcpOiBudW1iZXIge1xuICAgIHJldHVybiBUb2tlbi5hc051bWJlcih0aGlzLmludGVycG9sYXRpb25Gb3JPdXRwdXQob3V0cHV0KSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0Qm9vbGVhbihvdXRwdXQ6IHN0cmluZyk6IElSZXNvbHZhYmxlIHtcbiAgICByZXR1cm4gdGhpcy5pbnRlcnBvbGF0aW9uRm9yT3V0cHV0KG91dHB1dCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0TGlzdChvdXRwdXQ6IHN0cmluZyk6IHN0cmluZ1tdIHtcbiAgICByZXR1cm4gVG9rZW4uYXNMaXN0KHRoaXMuaW50ZXJwb2xhdGlvbkZvck91dHB1dChvdXRwdXQpKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHsgLi4udGhpcy52YXJpYWJsZXMgfTtcbiAgfVxufVxuIl19