"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformLocal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
class TerraformLocal extends terraform_element_1.TerraformElement {
    constructor(scope, id, expression) {
        super(scope, id);
        this._expression = expression;
        this.fqn = tokens_1.Token.asString(tfExpression_1.ref(`local.${this.friendlyUniqueId}`, this.cdktfStack));
    }
    set expression(value) {
        this._expression = value;
    }
    get expression() {
        return tokens_1.Token.asAny(this.interpolation());
    }
    get asString() {
        return tokens_1.Token.asString(this.interpolation());
    }
    get asNumber() {
        return tokens_1.Token.asNumber(this.interpolation());
    }
    get asList() {
        return tokens_1.Token.asList(this.interpolation());
    }
    get asBoolean() {
        return this.interpolation();
    }
    interpolation() {
        return tfExpression_1.ref(`local.${this.friendlyUniqueId}`, this.cdktfStack);
    }
    toTerraform() {
        return {
            locals: {
                [this.friendlyUniqueId]: this._expression,
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                local: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformLocal = TerraformLocal;
_a = JSII_RTTI_SYMBOL_1;
TerraformLocal[_a] = { fqn: "cdktf.TerraformLocal", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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