import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { ITerraformDependable } from "./terraform-dependable";
export interface TerraformModuleOptions {
    readonly source: string;
    readonly version?: string;
    readonly providers?: (TerraformProvider | TerraformModuleProvider)[];
    readonly dependsOn?: ITerraformDependable[];
}
export interface TerraformModuleProvider {
    readonly provider: TerraformProvider;
    readonly moduleAlias: string;
}
export declare abstract class TerraformModule extends TerraformElement implements ITerraformDependable {
    readonly source: string;
    readonly version?: string;
    private _providers?;
    dependsOn?: string[];
    readonly fqn: string;
    constructor(scope: Construct, id: string, options: TerraformModuleOptions);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    interpolationForOutput(moduleOutput: string): import("./tokens").IResolvable;
    getString(output: string): string;
    get providers(): (TerraformProvider | TerraformModuleProvider)[] | undefined;
    addProvider(provider: TerraformProvider | TerraformModuleProvider): void;
    toTerraform(): any;
    toMetadata(): any;
    private validateIfProvidersHaveUniqueKeys;
}
