"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const terraform_provider_1 = require("./terraform-provider");
const util_1 = require("./util");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
const terraform_asset_1 = require("./terraform-asset");
class TerraformModule extends terraform_element_1.TerraformElement {
    constructor(scope, id, options) {
        super(scope, id);
        if (options.source.startsWith("./") || options.source.startsWith("../")) {
            // Create an asset for the local module for better TFC support
            const asset = new terraform_asset_1.TerraformAsset(scope, `local-module-${id}`, {
                path: options.source,
            });
            // Despite being a relative path already, further indicate it as such for Terraform handling
            this.source = `./${asset.path}`;
        }
        else {
            this.source = options.source;
        }
        this.version = options.version;
        this._providers = options.providers;
        this.validateIfProvidersHaveUniqueKeys();
        if (Array.isArray(options.dependsOn)) {
            this.dependsOn = options.dependsOn.map((dependency) => tfExpression_1.insideTfExpression(dependency.fqn));
        }
        this.fqn = tokens_1.Token.asString(tfExpression_1.ref(`module.${this.friendlyUniqueId}`, this.cdktfStack));
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    interpolationForOutput(moduleOutput) {
        return tfExpression_1.ref(`module.${this.friendlyUniqueId}.${moduleOutput}`, this.cdktfStack);
    }
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForOutput(output));
    }
    get providers() {
        return this._providers;
    }
    addProvider(provider) {
        if (!this._providers) {
            this._providers = [];
        }
        this._providers.push(provider);
        this.validateIfProvidersHaveUniqueKeys();
    }
    toTerraform() {
        var _b;
        const attributes = util_1.deepMerge({
            ...this.synthesizeAttributes(),
            source: this.source,
            version: this.version,
            providers: (_b = this._providers) === null || _b === void 0 ? void 0 : _b.reduce((a, p) => {
                if (p instanceof terraform_provider_1.TerraformProvider) {
                    return { ...a, [p.terraformResourceType]: p.fqn };
                }
                else {
                    return {
                        ...a,
                        [`${p.provider.terraformResourceType}.${p.moduleAlias}`]: p.provider.fqn,
                    };
                }
            }, {}),
            depends_on: this.dependsOn,
        }, this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            module: {
                [this.friendlyUniqueId]: attributes,
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [`module.${this.source}`]: Object.keys(this.rawOverrides),
            },
        };
    }
    validateIfProvidersHaveUniqueKeys() {
        var _b;
        const moduleAliases = (_b = this._providers) === null || _b === void 0 ? void 0 : _b.map((p) => {
            if (p instanceof terraform_provider_1.TerraformProvider) {
                return p.terraformResourceType;
            }
            else {
                return `${p.provider.terraformResourceType}.${p.moduleAlias}`;
            }
        });
        const uniqueModuleAliases = new Set();
        moduleAliases === null || moduleAliases === void 0 ? void 0 : moduleAliases.forEach((alias) => {
            if (uniqueModuleAliases.has(alias)) {
                throw new Error(`Error: Multiple providers have the same alias: "${alias}"`);
            }
            uniqueModuleAliases.add(alias);
        });
    }
}
exports.TerraformModule = TerraformModule;
_a = JSII_RTTI_SYMBOL_1;
TerraformModule[_a] = { fqn: "cdktf.TerraformModule", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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